/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sha1Encoder {
    protected static final Logger logger = LoggerFactory.getLogger(Sha1Encoder.class);

    private Sha1Encoder() {
        throw new IllegalAccessError("Utility class");
    }

    public static byte[] rawEncode(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            MessageDigest SHA1 = MessageDigest.getInstance("SHA-1");
            SHA1.update(data, 0, data.length);
            return SHA1.digest();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String encode(byte[] data) {
        byte[] md5Code = Sha1Encoder.rawEncode(data);
        if (md5Code != null) {
            return new String(Hex.encodeHex((byte[])md5Code));
        }
        return null;
    }

    public static String encode(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        return Sha1Encoder.encode(data.getBytes());
    }

    public static String encodeBase64(byte[] data, boolean urlSafe) {
        byte[] md5Code = Sha1Encoder.rawEncode(data);
        if (md5Code != null) {
            return new String(urlSafe ? Base64.encodeBase64URLSafe((byte[])md5Code) : Base64.encodeBase64((byte[])md5Code));
        }
        return null;
    }

    public static String encodeBase64(String data, boolean urlSafe) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        return Sha1Encoder.encodeBase64(data.getBytes(), urlSafe);
    }
}

