/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.repository.mapping;

import com.couchbase.client.java.document.EntityDocument;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.repository.mapping.EntityConverter;
import com.couchbase.client.java.repository.mapping.EntityMetadata;
import com.couchbase.client.java.repository.mapping.PropertyMetadata;
import com.couchbase.client.java.repository.mapping.ReflectionBasedEntityMetadata;
import com.couchbase.client.java.repository.mapping.RepositoryMappingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultEntityConverter
implements EntityConverter<JsonDocument> {
    private final Map<Class<?>, EntityMetadata> metadataCache = new ConcurrentHashMap();

    @Override
    public JsonDocument fromEntity(EntityDocument<Object> source) {
        Object document = source.content();
        EntityMetadata entityMetadata = this.metadata(document.getClass());
        String id = source.id();
        if (id == null) {
            DefaultEntityConverter.verifyId(entityMetadata);
            id = (String)entityMetadata.idProperty().get(document);
            if (id == null || id.isEmpty()) {
                throw new RepositoryMappingException("The @Id field cannot be null or empty.");
            }
        }
        JsonObject content = JsonObject.create();
        for (PropertyMetadata propertyMetadata : entityMetadata.properties()) {
            if (propertyMetadata.isId()) continue;
            String name = propertyMetadata.name();
            Class<?> type = propertyMetadata.type();
            Object value = propertyMetadata.get(document);
            String encryptionProviderName = propertyMetadata.encryptionProviderName();
            if (value == null || value instanceof String || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Double) {
                if (encryptionProviderName != null) {
                    content.putAndEncrypt(name, value, encryptionProviderName);
                    continue;
                }
                content.put(name, value);
                continue;
            }
            throw new RepositoryMappingException("Unsupported field type: " + type);
        }
        return JsonDocument.create(id, source.expiry(), content, source.cas());
    }

    @Override
    public <T> EntityDocument<T> toEntity(JsonDocument source, Class<T> clazz) {
        try {
            EntityMetadata entityMetadata = this.metadata(clazz);
            T instance = clazz.newInstance();
            if (source.content() != null) {
                for (PropertyMetadata propertyMetadata : entityMetadata.properties()) {
                    String fieldName = propertyMetadata.name();
                    if (((JsonObject)source.content()).containsKey("__crypt_" + fieldName)) {
                        propertyMetadata.set(((JsonObject)source.content()).getAndDecrypt(fieldName, propertyMetadata.encryptionProviderName()), instance);
                        continue;
                    }
                    if (!((JsonObject)source.content()).containsKey(fieldName)) continue;
                    propertyMetadata.set(((JsonObject)source.content()).get(fieldName), instance);
                }
            }
            if (entityMetadata.hasIdProperty()) {
                entityMetadata.idProperty().set(source.id(), instance);
            }
            return EntityDocument.create(source.id(), source.expiry(), instance, source.cas());
        }
        catch (Exception e) {
            throw new RepositoryMappingException("Could not instantiate entity.", e);
        }
    }

    private EntityMetadata metadata(Class<?> source) {
        EntityMetadata metadata = this.metadataCache.get(source);
        if (metadata == null) {
            ReflectionBasedEntityMetadata generated = new ReflectionBasedEntityMetadata(source);
            this.metadataCache.put(source, generated);
            return generated;
        }
        return metadata;
    }

    private static void verifyId(EntityMetadata entityMetadata) {
        if (!entityMetadata.hasIdProperty()) {
            throw new RepositoryMappingException("No field annotated with @Id present.");
        }
        if (entityMetadata.idProperty().type() != String.class) {
            throw new RepositoryMappingException("The @Id Field needs to be of type String.");
        }
    }
}

