/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.protobuf;

public class ProtobufUtil {
    public static final int SECONDARY_BUFFER_LENGTH = 64000;
    public static final int[] sUtf8UnitLengths;

    public static byte[] allocSecondary(byte[] curr) {
        return new byte[64000];
    }

    public static int lengthLength(int len) {
        if (len <= 127) {
            return 1;
        }
        if (len <= 16383) {
            return 2;
        }
        if (len <= 0x1FFFFF) {
            return 3;
        }
        if (len <= 0x1FFFFF) {
            return 3;
        }
        if (len <= 0xFFFFFFF) {
            return 4;
        }
        return 5;
    }

    public static int appendLengthLength(int len, byte[] buffer, int ptr) {
        if (len <= 127) {
            buffer[ptr++] = (byte)len;
            return ptr;
        }
        do {
            buffer[ptr++] = (byte)(128 + (len & 0x7F));
        } while ((len >>= 7) > 127);
        buffer[ptr++] = (byte)len;
        return ptr;
    }

    public static byte[] lengthAsBytes(int len) {
        int bytes = ProtobufUtil.lengthLength(len);
        byte[] result = new byte[bytes];
        int last = bytes - 1;
        for (int i = 0; i < last; ++i) {
            result[i] = (byte)(128 + (len & 0x7F));
            len >>= 7;
        }
        result[last] = (byte)len;
        return result;
    }

    public static int zigzagEncode(int input) {
        return input << 1 ^ input >> 31;
    }

    public static int zigzagDecode(int encoded) {
        return encoded >>> 1 ^ -(encoded & 1);
    }

    public static long zigzagEncode(long input) {
        return input << 1 ^ input >> 63;
    }

    public static long zigzagDecode(long encoded) {
        return encoded >>> 1 ^ -(encoded & 1L);
    }

    static {
        int[] table = new int[256];
        for (int c = 128; c < 256; ++c) {
            int code = (c & 0xE0) == 192 ? 1 : ((c & 0xF0) == 224 ? 2 : ((c & 0xF8) == 240 ? 3 : -1));
            table[c] = code;
        }
        sUtf8UnitLengths = table;
    }
}

