/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.client;

import hector.me.prettyprint.cassandra.serializers.BytesArraySerializer;
import hector.me.prettyprint.cassandra.serializers.StringSerializer;
import hector.me.prettyprint.hector.api.Keyspace;
import hector.me.prettyprint.hector.api.Serializer;
import hector.me.prettyprint.hector.api.beans.HColumn;
import hector.me.prettyprint.hector.api.beans.HSuperColumn;
import hector.me.prettyprint.hector.api.beans.SuperSlice;
import hector.me.prettyprint.hector.api.factory.HFactory;
import hector.me.prettyprint.hector.api.query.QueryResult;
import hector.me.prettyprint.hector.api.query.SuperSliceQuery;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.extend.client.BlobBean;
import org.apache.cassandra.extend.client.FFSClientCommonModule;
import org.apache.cassandra.extend.client.FFSException;
import org.apache.cassandra.extend.client.FFSLoadBalancingPolicy;
import org.apache.cassandra.extend.midlayer.common.BlockIndex;
import org.apache.cassandra.extend.midlayer.common.Constants;
import org.apache.cassandra.extend.midlayer.common.KeyEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class FFSClientReadModule {
    private static final Log logger = LogFactory.getLog(FFSClientReadModule.class);
    private final FFSClientCommonModule commonModule;
    private final String charsetName;

    FFSClientReadModule(FFSClientCommonModule commonModule) {
        this.charsetName = null;
        this.commonModule = commonModule;
    }

    FFSClientReadModule(FFSClientCommonModule commonModule, String charsetName) {
        this.charsetName = charsetName;
        this.commonModule = commonModule;
    }

    BlobBean getBlobBean(String cfName, String key, OutputStream blobOS) throws FFSException, IOException {
        BlobBean blobBean = new BlobBean(blobOS);
        String chunkIndex = "001";
        String version = "0000000000000000000";
        while (true) {
            this.getBlockAndFillToBlobBean(cfName, key, version, chunkIndex, new String[]{"meta", "version", "blob"}, blobBean, 0, Integer.MAX_VALUE);
            if (blobBean.attendLastBlock()) break;
            chunkIndex = BlockIndex.getNextIndexOfSplitedByString(chunkIndex);
            version = String.valueOf(blobBean.getVersion());
        }
        return blobBean;
    }

    BlobBean getBlobBean(String cfName, String key, long recordVersionFromUser, long startPosition, long endPosition, OutputStream blobOS) throws FFSException, IOException {
        if (endPosition < Long.MAX_VALUE && endPosition - startPosition > Integer.MAX_VALUE) {
            throw new IOException(String.format("endPosition is too big:%d", endPosition));
        }
        BlobBean blobBean = new BlobBean(blobOS);
        String chunkIndex = "001";
        String version = "0000000000000000000";
        long skipLength = 0L;
        int currentBlockSize = 0;
        while (true) {
            Map<String, String> metas = this.getMetaOfOneChunk(cfName, key, version, chunkIndex);
            this.checkRecordVersionFromUserAndRecordVersionFromBlock(recordVersionFromUser, this.getRecordVersion(metas, cfName, key), cfName, key);
            version = recordVersionFromUser + "";
            currentBlockSize = this.getBlockSize(metas, cfName, key);
            if ((skipLength += (long)currentBlockSize) > startPosition) break;
            chunkIndex = BlockIndex.getNextIndexOfSplitedByString(chunkIndex);
        }
        int lengthRequired = (int)(endPosition - startPosition) + 1;
        int lengthOfBlockShouldBeWriteToBlobBeanOutput = Math.min((int)(skipLength - startPosition), lengthRequired);
        int startPositionRequiredOfSpecialBlock = currentBlockSize - (int)(skipLength - startPosition);
        while (true) {
            this.getBlockAndFillToBlobBean(cfName, key, version, chunkIndex, new String[]{"meta", "blob"}, blobBean, startPositionRequiredOfSpecialBlock, lengthOfBlockShouldBeWriteToBlobBeanOutput);
            this.checkRecordVersionFromUserAndRecordVersionFromBlock(recordVersionFromUser, this.getRecordVersion(blobBean.getMeta(), cfName, key), cfName, key);
            if (blobBean.attendLastBlock()) break;
            version = this.getRecordVersion(blobBean.getMeta(), cfName, key) + "";
            chunkIndex = BlockIndex.getNextIndexOfSplitedByString(chunkIndex);
            int n = lengthOfBlockShouldBeWriteToBlobBeanOutput = endPosition == Long.MAX_VALUE ? Integer.MAX_VALUE : (int)(endPosition + 1L - (startPosition + blobBean.getSumSizeOfCurrentContent()));
            if (lengthOfBlockShouldBeWriteToBlobBeanOutput <= 0) break;
            startPositionRequiredOfSpecialBlock = 0;
        }
        return blobBean;
    }

    BlobBean getOneBlock(String cfName, String key, String recordVersion, String chunkIndex, String[] columnNames) throws FFSException, IOException {
        BlobBean blobBean = new BlobBean(null);
        this.getBlockAndFillToBlobBean(cfName, key, recordVersion, chunkIndex, columnNames, blobBean, 0, Integer.MAX_VALUE);
        return blobBean;
    }

    long getRecordVersion(String cfName, String key) throws FFSException {
        Map<String, String> metas = this.getMetaOfOneChunk(cfName, key, "0000000000000000000", "001");
        return this.getRecordVersion(metas, cfName, key);
    }

    String getMD5(String cfName, String key) throws FFSException {
        Map<String, String> metas = this.getMetaOfOneChunk(cfName, key, "0000000000000000000", "001");
        String recordMD5 = metas.get("meta_ffs_blob_MD5_name");
        return recordMD5;
    }

    private void checkRecordVersionFromUserAndRecordVersionFromBlock(long recordVersionFromUser, long recordVersionFromBlock, String cfName, String key) throws FFSException {
        if (recordVersionFromUser != recordVersionFromBlock) {
            throw new FFSException(String.format("record %s %s has been updated,you must download it from start point!", cfName, key));
        }
    }

    private Map<String, String> getMetaOfOneChunk(String cfName, String key, String version, String chunkIndex) throws FFSException {
        try {
            BlobBean blobBean = this.getOneBlock(cfName, key, version, chunkIndex, new String[]{"meta"});
            return blobBean.getMeta();
        }
        catch (IOException e) {
            throw new RuntimeException("should not throw IOException in getBlobMeta()", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getBlockAndFillToBlobBean(String cfName, String bussinessKey, String recordVersion, String chunkIndex, String[] columnNames, BlobBean blobBeanOutPut, int start, int lengthOfBlockShouldBeWriteToBlobBeanOutput) throws FFSException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Consistency DEBUG  start get blob for %s ~ %s ~ %s ", cfName, bussinessKey, recordVersion + chunkIndex));
        }
        long startTime = System.currentTimeMillis();
        this.commonModule.checkBussinessKey(bussinessKey);
        KeyEntity key = new KeyEntity(bussinessKey + '~' + chunkIndex + recordVersion + 'b');
        SuperSliceQuery supercolumnQuery = HFactory.createSuperSliceQuery((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        supercolumnQuery.setKey((Object)key.getFullKey()).setColumnFamily(cfName).setColumnNames((Object[])columnNames);
        QueryResult result = null;
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.READ);
                result = supercolumnQuery.execute();
            }
            catch (Exception e) {
                block18: {
                    try {
                        String errorMsg = this.commonModule.dealOperationException(e, cfName, key, i);
                        if (i != tryNum - 1) break block18;
                        throw new FFSException(errorMsg, e);
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)String.format("Consistency DEBUG  end get blob for %s ~ %s ~ %s ,spend Time:%d ms", cfName, bussinessKey, recordVersion + chunkIndex, System.currentTimeMillis() - startTime));
                        }
                        this.commonModule.removeCurrentLoadBalanceRequestBean();
                        throw throwable;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Consistency DEBUG  end get blob for %s ~ %s ~ %s ,spend Time:%d ms", cfName, bussinessKey, recordVersion + chunkIndex, System.currentTimeMillis() - startTime));
                }
                this.commonModule.removeCurrentLoadBalanceRequestBean();
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Consistency DEBUG  end get blob for %s ~ %s ~ %s ,spend Time:%d ms", cfName, bussinessKey, recordVersion + chunkIndex, System.currentTimeMillis() - startTime));
            }
            this.commonModule.removeCurrentLoadBalanceRequestBean();
            break;
        }
        SuperSlice columns = (SuperSlice)result.get();
        HSuperColumn valuesAsSuperColumn = columns.getColumnByName((Object)"values");
        List values = valuesAsSuperColumn.getColumns();
        for (HColumn column : values) {
            if ("meta".equals(column.getName())) {
                String metaStr;
                HashMap<String, String> metas = new HashMap<String, String>();
                String string = metaStr = this.charsetName == null ? new String((byte[])column.getValue(), Constants.UTF_8) : new String((byte[])column.getValue(), this.charsetName);
                if (metaStr != null && metaStr.length() > 0) {
                    String[] meta_key_values;
                    for (String meta_key_value : meta_key_values = metaStr.split("~~")) {
                        String[] key_value = meta_key_value.split("~");
                        if (key_value.length == 1) {
                            metas.put(key_value[0], "");
                            continue;
                        }
                        metas.put(key_value[0], key_value[1]);
                    }
                }
                blobBeanOutPut.setMeta(metas);
                continue;
            }
            if ("timestamp".equals(column.getName())) {
                blobBeanOutPut.setTimestamp(FFSClientReadModule.makeLong((byte[])column.getValue()));
                continue;
            }
            if ("version".equals(column.getName())) {
                blobBeanOutPut.setVersion(new String((byte[])column.getValue()));
                continue;
            }
            if ("blob".equals(column.getName())) {
                byte[] blockValue = (byte[])column.getValue();
                if (lengthOfBlockShouldBeWriteToBlobBeanOutput == Integer.MAX_VALUE || lengthOfBlockShouldBeWriteToBlobBeanOutput >= blockValue.length) {
                    blobBeanOutPut.addBlob(blockValue);
                    continue;
                }
                byte[] blockValuePart = new byte[lengthOfBlockShouldBeWriteToBlobBeanOutput];
                System.arraycopy(blockValue, start, blockValuePart, 0, lengthOfBlockShouldBeWriteToBlobBeanOutput);
                blobBeanOutPut.addBlob(blockValuePart);
                continue;
            }
            if (!"is_last_chunk".equals(column.getName())) continue;
            blobBeanOutPut.setLastChunkFlag(ByteBuffer.wrap((byte[])column.getValue()));
        }
    }

    private int getBlockSize(Map<String, String> metas, String cfName, String key) throws FFSException {
        String blockSize = metas.get("ffs_s");
        if (blockSize == null) {
            throw new FFSException(String.format("In old FFS version we did not write block size and version in meta,so you can not download this record %s %s by broken point!", cfName, key));
        }
        return Integer.parseInt(blockSize);
    }

    private long getRecordVersion(Map<String, String> metas, String cfName, String key) throws FFSException {
        String recordVersion = metas.get("ffs_v");
        if (recordVersion == null) {
            throw new FFSException(String.format("In old FFS version we did not write block size and version in meta,so you can not download this record %s %s by broken point!", cfName, key));
        }
        return Long.parseLong(recordVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRecordSize(String cfName, String bussinessKey) throws FFSException {
        KeyEntity key = new KeyEntity(bussinessKey + '~' + "001" + "0000000000000000000" + 'b');
        SuperSliceQuery supercolumnQuery = HFactory.createSuperSliceQuery((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        supercolumnQuery.setKey((Object)key.getFullKey()).setColumnFamily(cfName).setColumnNames((Object[])new String[]{"RECORD_LENGTH"});
        QueryResult result = null;
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.READ);
                result = supercolumnQuery.execute();
                break;
            }
            catch (Exception e) {
                String errorMsg = this.commonModule.dealOperationException(e, cfName, key, i);
                if (i != tryNum - 1) continue;
                throw new FFSException(errorMsg, e);
            }
            finally {
                this.commonModule.removeCurrentLoadBalanceRequestBean();
            }
        }
        SuperSlice columns = (SuperSlice)result.get();
        HColumn hColumn = columns.getColumnByName((Object)"values").get(0);
        String size = new String((byte[])hColumn.getValue());
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] topRecord(long num, String cfName) throws FFSException {
        SuperSlice columns;
        HSuperColumn valuesAsSuperColumn;
        List values;
        String keys;
        String key = "0~0000000000000000000000a";
        SuperSliceQuery supercolumnQuery = HFactory.createSuperSliceQuery((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        supercolumnQuery.setKey((Object)key).setColumnFamily(cfName).setColumnNames((Object[])new String[]{"TOP_RECORD", num + ""});
        QueryResult result = null;
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.commonModule.addLoadBalanceRequestBean(new KeyEntity(key), FFSLoadBalancingPolicy.OperationType.READ);
                result = supercolumnQuery.execute();
                break;
            }
            catch (Exception e) {
                String errorMsg = this.commonModule.dealOperationException(e, cfName, new KeyEntity(key), i);
                if (i != tryNum - 1) continue;
                throw new FFSException(errorMsg, e);
            }
            finally {
                this.commonModule.removeCurrentLoadBalanceRequestBean();
            }
        }
        if ((keys = new String((byte[])((HColumn)(values = (valuesAsSuperColumn = (columns = (SuperSlice)result.get()).getColumnByName((Object)"values")).getColumns()).get(0)).getValue())) != null && keys.length() > 0) {
            return keys.split("~");
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBackupInfosOfSpecialBID(String cfName, String bussinessKey) throws FFSException {
        KeyEntity key = new KeyEntity(bussinessKey + '~' + "001" + "0000000000000000000" + 'b');
        SuperSliceQuery supercolumnQuery = HFactory.createSuperSliceQuery((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        supercolumnQuery.setKey((Object)key.getFullKey()).setColumnFamily(cfName).setColumnNames((Object[])new String[]{"BACKUP_INFOS"});
        QueryResult result = null;
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.READ);
                result = supercolumnQuery.execute();
                break;
            }
            catch (Exception e) {
                String errorMsg = this.commonModule.dealOperationException(e, cfName, key, i);
                if (i != tryNum - 1) continue;
                throw new FFSException(errorMsg, e);
            }
            finally {
                this.commonModule.removeCurrentLoadBalanceRequestBean();
            }
        }
        SuperSlice columns = (SuperSlice)result.get();
        HColumn hColumn = columns.getColumnByName((Object)"values").get(0);
        String backupInfos = new String((byte[])hColumn.getValue());
        return backupInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getBlobSize(String cfName, String blobMD5) throws FFSException {
        KeyEntity key = new KeyEntity(blobMD5 + '~' + "001" + "0000000000000000000" + 'b');
        SuperSliceQuery supercolumnQuery = HFactory.createSuperSliceQuery((Keyspace)this.commonModule.getKeyspace(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)BytesArraySerializer.get());
        supercolumnQuery.setKey((Object)key.getFullKey()).setColumnFamily(cfName).setColumnNames((Object[])new String[]{"JUDGE_BLOB_EXISTING"});
        QueryResult result = null;
        int tryNum = 3;
        for (int i = 0; i < tryNum; ++i) {
            try {
                this.commonModule.addLoadBalanceRequestBean(key, FFSLoadBalancingPolicy.OperationType.READ);
                result = supercolumnQuery.execute();
                break;
            }
            catch (Exception e) {
                String errorMsg = this.commonModule.dealOperationException(e, cfName, key, i);
                if (i != tryNum - 1) continue;
                throw new FFSException(errorMsg, e);
            }
            finally {
                this.commonModule.removeCurrentLoadBalanceRequestBean();
            }
        }
        SuperSlice columns = (SuperSlice)result.get();
        HColumn hColumn = columns.getColumnByName((Object)"values").get(0);
        String blobSize = new String((byte[])hColumn.getValue());
        return new Integer(blobSize);
    }

    private static long makeLong(byte[] bytes) {
        if (bytes.length != 8) {
            throw new RuntimeException("illegal bytes length:" + bytes.length);
        }
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[7] & 0xFFL) << 0;
    }
}

