/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.thrift.commons.lang.StringUtils;

public class ErrorCodeConstants {
    public static final int MISS_PARTITION_ERROR = 100;
    public static final int CANNOT_ACCEPT_WRITE_ERROR = 101;
    public static final int CONSISTENCY_WRITE_ERROR = 102;
    public static final int SERVER_INNER_ERROR = 103;
    public static final int NONE_ACCEPT_WRITE_ERROR = 108;
    public static final int WRITE_SUFFICIENT_ERROR = 104;
    public static final int SERVER_MISS_PARTITION_ERROR = 105;
    public static final int READ_NOTEXIST_ERROR = 106;
    public static final int REQUEST_FORBIDEN = 107;
    public static final int BLOCK_VERSION_CONFLICT_ERROR = 109;
    public static final int INVALID_NODE_ERROR = 201;
    public static final int SERVER_INNER_ERROR_NEED_RETRY = 203;
    public static final int ALL_HOSTS_DOWN_ERROR_NEED_RETRY = 999;
    public static final String SIPLTED_ERRORCODE_WITH_ERRORMESSAGE_STR = "::";
    private static final List<Integer> errorCodes = new ArrayList<Integer>();
    private static final List<Integer> retryErrorCodes = new ArrayList<Integer>();

    public static boolean isValidErrorCode(String errorMessage) {
        String[] errorMessages = StringUtils.split((String)errorMessage, (String)SIPLTED_ERRORCODE_WITH_ERRORMESSAGE_STR);
        if (errorMessages == null || errorMessages.length == 0) {
            return false;
        }
        try {
            Integer errorCode = Integer.valueOf(errorMessages[0]);
            return errorCodes.contains(errorCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidRetryErrorCode(String errorMessage) {
        String[] errorMessages = StringUtils.split((String)errorMessage, (String)SIPLTED_ERRORCODE_WITH_ERRORMESSAGE_STR);
        if (errorMessages == null || errorMessages.length == 0) {
            return false;
        }
        try {
            Integer errorCode = Integer.valueOf(errorMessages[0]);
            return retryErrorCodes.contains(errorCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        errorCodes.add(100);
        errorCodes.add(101);
        errorCodes.add(102);
        errorCodes.add(103);
        errorCodes.add(104);
        errorCodes.add(105);
        errorCodes.add(106);
        errorCodes.add(108);
        retryErrorCodes.add(201);
        retryErrorCodes.add(203);
        retryErrorCodes.add(101);
    }
}

