/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import java.util.List;
import org.apache.cassandra.extend.midlayer.common.NodeContext;
import org.apache.cassandra.extend.midlayer.dbengine.IZookeeperClientWrapper;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GroupsInfoTracker {
    private static Logger logger = Logger.getLogger(GroupsInfoTracker.class);
    private IZookeeperClientWrapper zookeeperClientWrapper = this.getZookeeperClientWrapper();
    private String GROUPS_ROOT_PATH = "/groups";

    public GroupsInfoTracker() {
        String currentGroupNodePath = this.getGroupNodePath(this.getGroupNameOfCurrentNonde());
        this.zookeeperClientWrapper.createPersistent(currentGroupNodePath);
    }

    IZookeeperClientWrapper getZookeeperClientWrapper() {
        IZookeeperClientWrapper zookeeperClientWrapper = NodeContext.getInstance().getInstanceFromInjector(IZookeeperClientWrapper.class);
        return zookeeperClientWrapper;
    }

    String getGroupNameOfCurrentNonde() {
        String groupName = NodeContext.getInstance().getNodeInfo().getGroupName();
        return groupName;
    }

    public List<String> getAllGroups() {
        return this.zookeeperClientWrapper.getChildren(this.GROUPS_ROOT_PATH);
    }

    public String getGroupNodePath(String groupName) {
        Object[] pathElements = new String[]{this.GROUPS_ROOT_PATH, groupName};
        String groupNodePath = StringUtils.join((Object[])pathElements, (String)"/");
        return groupNodePath;
    }

    public static void main(String[] args) {
    }

    public void clearGroupInfoWhenRemoveGroup(String group, NodeContext.NodeContextInvokeID nodeContextInvokeID) {
        if (nodeContextInvokeID == null) {
            throw new RuntimeException("clearGroupInfoWhenRemoveGroup must used by nodecontext for remove endpoint!");
        }
        String path = this.getGroupNodePath(group);
        if (path.endsWith("/" + group)) {
            logger.info((Object)("I will clear groupInfo zk data for " + path));
            this.zookeeperClientWrapper.deleteRecursive(path);
        } else {
            logger.error((Object)("group choose error,so I will not clear groupInfo zk data for:" + path));
        }
    }
}

