/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import hector.me.prettyprint.hector.api.exceptions.HectorException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.simple.JSONObject;

public class PartitionTable
implements Serializable {
    private static final long serialVersionUID = 5848291843185325018L;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, PartitionGroup>> partitionTables = new ConcurrentHashMap();
    private static final Object synChangeNodeStatus = new Object();

    public void setPartitonTable(String dc, ConcurrentHashMap<String, PartitionGroup> pt) {
        this.partitionTables.put(dc, pt);
    }

    ConcurrentHashMap<String, ConcurrentHashMap<String, PartitionGroup>> getPartitionTables() {
        return this.partitionTables;
    }

    public void clearPartitionTable() {
        this.partitionTables.clear();
    }

    public boolean isEmpty() {
        return this.partitionTables == null || this.partitionTables.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPartitionTables(PartitionTable newPartitionTable) {
        if (this.partitionTables.isEmpty()) {
            this.partitionTables.putAll(newPartitionTable.getPartitionTables());
        } else {
            Set<Node> oldNodes = this.getAllPartitionTableHost();
            Set<Node> newNodes = newPartitionTable.getAllPartitionTableHost();
            Object object = synChangeNodeStatus;
            synchronized (object) {
                this.partitionTables.putAll(newPartitionTable.getPartitionTables());
                for (Node newNode : newNodes) {
                    for (Node oldNode : oldNodes) {
                        if (!newNode.equals(oldNode)) continue;
                        newNode.setNodeStatus(oldNode.getNodeStatus());
                    }
                }
            }
        }
    }

    public Set<Node> getAllPartitionTableHost() {
        HashSet<Node> result = new HashSet<Node>();
        for (ConcurrentHashMap<String, PartitionGroup> dcPerPartitionTables : this.partitionTables.values()) {
            for (PartitionGroup group : dcPerPartitionTables.values()) {
                result.addAll(group.getNodesInGroup());
            }
        }
        return result;
    }

    public Set<Node> getAllPartitionTableHost(String dc) {
        HashSet<Node> result = new HashSet<Node>();
        for (PartitionGroup group : this.partitionTables.get(dc).values()) {
            result.addAll(group.getNodesInGroup());
        }
        return result;
    }

    private List<Node> getNodesInPartitionGroup(String dc, String partitionId) {
        return this.partitionTables.get(dc).get(partitionId).getNodesInGroup();
    }

    public String belongWhichDC(String ip) {
        for (String dc : this.partitionTables.keySet()) {
            for (PartitionGroup group : this.partitionTables.get(dc).values()) {
                for (Node node : group.getNodesInGroup()) {
                    if (!node.getAddress().getHostAddress().equals(ip)) continue;
                    return dc;
                }
            }
        }
        throw new RuntimeException("not contain this node:" + ip);
    }

    public Node getWritableNode(String dc, String partitionId) {
        List<Node> partitionNodes = this.getNodesInPartitionGroup(dc, partitionId);
        for (Node node : partitionNodes) {
            if (!Status.writable.equals((Object)node.getNodeStatus())) continue;
            return node;
        }
        if (this.getValidNode(dc, partitionId).size() > 0) {
            return this.getValidNode(dc, partitionId).get(0);
        }
        throw new HectorException("999::getWritableNode error caused by all the node is invalid for group. Retry burden pushed out to client.");
    }

    public List<Node> getValidNode(String dc, String partitionId) {
        ArrayList<Node> partitionNodes = new ArrayList<Node>();
        for (Node node : this.getNodesInPartitionGroup(dc, partitionId)) {
            if (Status.invalid.equals((Object)node.getNodeStatus())) continue;
            partitionNodes.add(node);
        }
        return partitionNodes;
    }

    public Node getNodeWithHosts(String hosts) {
        for (String dc : this.partitionTables.keySet()) {
            for (PartitionGroup group : this.partitionTables.get(dc).values()) {
                for (Node node : group.getNodesInGroup()) {
                    if (!node.getAddress().getHostAddress().equals(hosts)) continue;
                    return node;
                }
            }
        }
        return null;
    }

    public String getPartitionTableAsJsonOfSpecialDC(String dc) {
        ConcurrentHashMap<String, PartitionGroup> partitionTablesOfSpecialDC = this.partitionTables.get(dc);
        HashMap group_partions = new HashMap();
        HashMap group_endpoints = new HashMap();
        for (String partitionID : partitionTablesOfSpecialDC.keySet()) {
            PartitionGroup currentPartitionGroup = partitionTablesOfSpecialDC.get(partitionID);
            List partitionIDsOfCurrentGroup = (List)group_partions.get(currentPartitionGroup.group);
            if (partitionIDsOfCurrentGroup == null) {
                group_partions.put(currentPartitionGroup.group, new ArrayList());
                partitionIDsOfCurrentGroup = (List)group_partions.get(currentPartitionGroup.group);
            }
            partitionIDsOfCurrentGroup.add(partitionID);
            List endpointIPsOfCurrentGroup = (List)group_endpoints.get(currentPartitionGroup.group);
            if (endpointIPsOfCurrentGroup != null) continue;
            group_endpoints.put(currentPartitionGroup.group, new ArrayList());
            endpointIPsOfCurrentGroup = (List)group_endpoints.get(currentPartitionGroup.group);
            for (Node node : currentPartitionGroup.nodesInGroup) {
                endpointIPsOfCurrentGroup.add(node.getHostAddress());
            }
            Collections.sort(endpointIPsOfCurrentGroup);
        }
        JSONObject obj = new JSONObject();
        LinkedList groups = new LinkedList();
        obj.put((Object)"groups", groups);
        for (String groupName : group_partions.keySet()) {
            LinkedHashMap group = new LinkedHashMap();
            group.put("partitions", group_partions.get(groupName));
            group.put("endpoints", group_endpoints.get(groupName));
            groups.add(group);
        }
        return obj.toJSONString();
    }

    public static enum Status {
        invalid,
        writable,
        readable;

    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = -8049820995878255612L;
        private InetAddress address;
        private Status nodeStatus = Status.readable;
        private long readWeight = 1L;

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Node) {
                Node node = (Node)obj;
                return node.getAddress().equals(this.getAddress());
            }
            return false;
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public Node(InetAddress address) {
            this.address = address;
        }

        public Node(InetAddress address, Long readWeight) {
            this.address = address;
            if (readWeight != null) {
                this.readWeight = readWeight;
            }
        }

        public Long getReadWeight() {
            return this.readWeight;
        }

        public String getHostAddress() {
            return this.address.getHostAddress();
        }

        public InetAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetAddress address) {
            this.address = address;
        }

        public Status getNodeStatus() {
            return this.nodeStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setNodeStatus(Status nodeStatus) {
            Object object = synChangeNodeStatus;
            synchronized (object) {
                this.nodeStatus = nodeStatus;
            }
        }
    }

    public static class PartitionGroup
    implements Serializable {
        private static final long serialVersionUID = -2478475744837879057L;
        private String group;
        private List<Node> nodesInGroup = new ArrayList<Node>();

        public List<Node> getNodesInGroup() {
            return this.nodesInGroup;
        }

        public void addNode(Node node) {
            this.nodesInGroup.add(node);
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }
    }
}

