/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.extend.midlayer.common.Constants;
import org.apache.cassandra.extend.midlayer.common.ValueMetas;
import org.apache.cassandra.extend.midlayer.dbengine.PersistenceFailureException;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;
import org.apache.cassandra.extend.midlayer.utils.Utils;

public class ValueMap {
    private static final ValueMapSerializer valueMapSerializer = new ValueMapSerializer();
    private Map<ByteBuffer, ByteBuffer> columns = new HashMap<ByteBuffer, ByteBuffer>();
    private long timestamp;
    private boolean isDelete;
    private char lastChunkFlag;
    private String version;
    private ValueMetas.ValueMetasProtector dataProtector = null;

    public ValueMap(long timestamp, boolean isDelete) {
        this.timestamp = timestamp;
        this.isDelete = isDelete;
    }

    public void putColumn(ByteBuffer columnName, ByteBuffer columnValue) {
        this.columns.put(columnName, columnValue);
        this.dataProtector = null;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public ByteBuffer getColumnValue(ByteBuffer columnName) {
        ByteBuffer ori = this.columns.get(columnName);
        if (ori == null) {
            return null;
        }
        return ori.duplicate();
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public Set<ByteBuffer> getColumnNames() {
        HashSet<ByteBuffer> ret = new HashSet<ByteBuffer>();
        for (ByteBuffer column : this.columns.keySet()) {
            ret.add(column.duplicate());
        }
        return ret;
    }

    public int size() {
        int ret = 0;
        for (ByteBuffer column : this.columns.values()) {
            ret += column.remaining();
        }
        return ret;
    }

    public void setToLastChunk() {
        this.lastChunkFlag = (char)98;
    }

    public boolean isLastChunk() {
        return 'b' == this.lastChunkFlag;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equalsOtherValueMap(ValueMap other) {
        if (other == null) {
            return false;
        }
        if (other.columns.size() != this.columns.size() || this.isDelete != other.isDelete) {
            return false;
        }
        for (ByteBuffer columnName : this.columns.keySet()) {
            ByteBuffer columnValue1 = this.getColumnValue(columnName);
            ByteBuffer columnValue2 = other.getColumnValue(columnName);
            if (columnValue1 != null && !columnValue1.equals(columnValue2)) {
                return false;
            }
            if (columnValue2 == null || columnValue2.equals(columnValue1)) continue;
            return false;
        }
        return true;
    }

    public void setBlockAllMetas(ValueMetas valueMetas, String blockVersion, Object invokeID) throws PersistenceFailureException {
        if (invokeID.getClass().getName().indexOf("org.apache.cassandra.extend.bdbengine.engine.BdbDatabaseEngine") < 0) {
            throw new RuntimeException(String.format("ValueMap.setBlockAllMetas can be invoke by %s!", invokeID.getClass().getName()));
        }
        this.setBlockAllMetas(valueMetas.getBlobMD5(), valueMetas.getRecordProperties(), valueMetas.getBlobSize(), valueMetas.getBlobSumSizeInRecord(), blockVersion);
    }

    private void setBlockAllMetas(String blobMD5, byte[] recordProperties, int blobSize, long blobSumSize, String blockVersion) throws PersistenceFailureException {
        String metaStr = "meta_ffs_blob_MD5_name~" + blobMD5;
        metaStr = metaStr + "~~ffs_s~" + blobSize;
        if (blobSumSize >= 0L) {
            metaStr = metaStr + "~~ffs_sum~" + blobSumSize;
        }
        metaStr = metaStr + "~~ffs_v~" + blockVersion;
        ByteBuffer metaByteBuffer = null;
        if (recordProperties == null || recordProperties.length == 0) {
            metaStr = metaStr + "~~ffs_sign~defalutDigitSign";
            byte[] metaByte = metaStr.getBytes(Constants.UTF_8);
            metaByteBuffer = ByteBuffer.wrap(metaByte);
        } else {
            String recordPropertiesStr = null;
            try {
                recordPropertiesStr = ByteBufferUtil.string(ByteBuffer.wrap(recordProperties), Constants.UTF_8);
            }
            catch (Exception e) {
                throw new PersistenceFailureException(103, "meta is not utf8!");
            }
            if (recordPropertiesStr.indexOf("ffs_sign") < 0) {
                metaStr = metaStr + "~~ffs_sign~defalutDigitSign";
            }
            byte[] metaByte = metaStr.getBytes(Constants.UTF_8);
            ByteBuffer[] allByteBuffers = new ByteBuffer[]{ByteBuffer.wrap(metaByte), ByteBuffer.wrap("~~".getBytes(Constants.UTF_8)), ByteBuffer.wrap(recordProperties)};
            metaByteBuffer = ByteBuffer.wrap(Utils.joinBytebuffers(allByteBuffers));
        }
        this.columns.put(Constants.VALUE_META, metaByteBuffer);
    }

    public ValueMetas extractValueMetas() throws PersistenceFailureException {
        if (this.isDelete()) {
            throw new RuntimeException("delete valueMap can not extract valueMetas!");
        }
        String blobMD5 = null;
        byte[] recordProperties = null;
        int blobSize = -1;
        ByteBuffer metaByteBuffer = this.columns.get(Constants.VALUE_META);
        if (metaByteBuffer == null) {
            throw new RuntimeException("metas should not be null,when extract meta!");
        }
        ValueMetas.CovertedString allMetaCovertedString = new ValueMetas.CovertedString(metaByteBuffer);
        String allMetaStr = allMetaCovertedString.getResult();
        HashMap<String, String> metas = new HashMap<String, String>();
        if (allMetaStr != null && allMetaStr.length() > 0) {
            String[] meta_key_values;
            for (String meta_key_value : meta_key_values = allMetaStr.split("~~")) {
                String[] key_value = meta_key_value.split("~");
                if (key_value.length == 1) {
                    metas.put(key_value[0], "");
                    continue;
                }
                metas.put(key_value[0], key_value[1]);
            }
        }
        blobMD5 = (String)metas.remove("meta_ffs_blob_MD5_name");
        if (this.columns.get(Constants.VALUE_BLOB) != null) {
            String blobMD5Calculated = Utils.calculateMD5(this.columns.get(Constants.VALUE_BLOB));
            if (blobMD5 == null || !blobMD5.equals(blobMD5Calculated)) {
                // empty if block
            }
            blobMD5 = blobMD5Calculated;
        }
        Utils.checkMD5Code(blobMD5);
        try {
            String blobSizeStr = (String)metas.remove("ffs_s");
            blobSize = Integer.parseInt(blobSizeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.columns.get(Constants.VALUE_BLOB) != null) {
            blobSize = this.columns.get(Constants.VALUE_BLOB).remaining();
        }
        if (blobSize < 0) {
            throw new RuntimeException("can not extra blob_size!");
        }
        metas.remove("ffs_v");
        metas.remove("ffs_sum");
        if ("defalutDigitSign".equals(metas.get("ffs_sign"))) {
            metas.remove("ffs_sign");
        }
        String recordPropertiesStr = "";
        for (String meta_key : metas.keySet()) {
            String meta_value = metas.get(meta_key) == null ? "" : (String)metas.get(meta_key);
            recordPropertiesStr = recordPropertiesStr + "~~" + meta_key + '~' + meta_value;
        }
        if (recordPropertiesStr.length() > 0) {
            recordPropertiesStr = recordPropertiesStr.substring("~~".length());
            recordProperties = recordPropertiesStr.getBytes(Constants.UTF_8);
        }
        ValueMetas ret = new ValueMetas(blobMD5, blobSize, recordProperties, allMetaCovertedString);
        ret.setDataProtector(this.dataProtector);
        return ret;
    }

    public static ValueMap deSerializeValue(byte[] valueObjectSerialized) {
        return valueMapSerializer.deSerialize(valueObjectSerialized);
    }

    public byte[] serializeValue() {
        return valueMapSerializer.serializeValue(this);
    }

    public void setDataProtector(ValueMetas.ValueMetasProtector dataProtector) {
        this.dataProtector = dataProtector;
    }

    private static class ValueMapSerializer {
        private static final int CURRENT_VALUEMAP_VERSION_INT = 900000000;
        private static final byte[] CURRENT_VALUEMAP_VERSION_FLAG = Utils.joinBytebuffers(new ByteBuffer[]{ByteBuffer.wrap(new byte[]{56}), ByteBufferUtil.bytes(900000000)});
        private static final int CURRENT_VALUEMAP_VERSION_FLAG_LENGTH = 5;

        private ValueMapSerializer() {
        }

        public ValueMap deSerialize(byte[] valueObjectSerialized) {
            this.checkValueMapSerializerVersionFormat();
            if (valueObjectSerialized.length > 5 && Arrays.equals(CURRENT_VALUEMAP_VERSION_FLAG, Arrays.copyOf(valueObjectSerialized, 5))) {
                return this.deSerializeNewImpl(valueObjectSerialized);
            }
            throw new RuntimeException("FFS3.x is should be updated to FFS4.0!");
        }

        private ValueMap deSerializeOldImpl(byte[] valueObjectSerialized) {
            ValueMap ret = new ValueMap(0L, this.isDeleted(valueObjectSerialized));
            ByteBuffer meta = this.getPureMeta(valueObjectSerialized);
            ByteBuffer blob = this.getBlob(valueObjectSerialized);
            ret.putColumn(Constants.VALUE_META, meta);
            ret.putColumn(Constants.VALUE_BLOB, blob);
            return ret;
        }

        private ValueMap deSerializeNewImpl(byte[] valueObjectSerialized) {
            boolean blobIsNull = valueObjectSerialized[5] == 48;
            valueObjectSerialized = Arrays.copyOfRange(valueObjectSerialized, 6, valueObjectSerialized.length);
            ValueMap ret = new ValueMap(0L, this.isDeleted(valueObjectSerialized));
            ByteBuffer meta = this.getPureMeta(valueObjectSerialized);
            ret.putColumn(Constants.VALUE_META, meta);
            if (!blobIsNull) {
                ByteBuffer blob = this.getBlob(valueObjectSerialized);
                ret.putColumn(Constants.VALUE_BLOB, blob);
            }
            return ret;
        }

        public byte[] serializeValue(ValueMap valueMap) {
            int metaLength_int;
            ByteBuffer blobValue;
            this.checkValueMapSerializerVersionFormat();
            byte[] blobIsNull = valueMap.getColumnValue(Constants.VALUE_BLOB) == null ? new byte[]{48} : new byte[]{49};
            ByteBuffer metaValue = valueMap.getColumnValue(Constants.VALUE_META);
            if (metaValue == null) {
                metaValue = ByteBuffer.wrap(new byte[0]);
            }
            if ((blobValue = valueMap.getColumnValue(Constants.VALUE_BLOB)) == null) {
                blobValue = ByteBuffer.wrap(new byte[0]);
            }
            if ((metaLength_int = 4 + metaValue.remaining()) > 4096) {
                // empty if block
            }
            ByteBuffer metaLength = ByteBufferUtil.bytes(metaLength_int);
            byte[] isDeleted = valueMap.isDelete() ? new byte[]{48} : new byte[]{49};
            ByteBuffer[] allByteBuffers = new ByteBuffer[]{ByteBuffer.wrap(CURRENT_VALUEMAP_VERSION_FLAG), ByteBuffer.wrap(blobIsNull), ByteBuffer.wrap(isDeleted), metaLength, metaValue, blobValue};
            return Utils.joinBytebuffers(allByteBuffers);
        }

        private ByteBuffer getBlob(byte[] valueObjectSerialized) {
            int metaLength = this.getMetaLength(valueObjectSerialized);
            ByteBuffer metaLengthByteBuffer = ByteBuffer.wrap(valueObjectSerialized, metaLength + 1, valueObjectSerialized.length - metaLength - 1);
            return metaLengthByteBuffer;
        }

        private ByteBuffer getPureMeta(byte[] valueObjectSerialized) {
            int metaLength = this.getMetaLength(valueObjectSerialized);
            ByteBuffer metaLengthByteBuffer = ByteBuffer.wrap(valueObjectSerialized, 5, metaLength - 4);
            return metaLengthByteBuffer;
        }

        private boolean isDeleted(byte[] valueObjectSerialized) {
            ByteBuffer isDeletedByteBuffer = ByteBuffer.wrap(valueObjectSerialized, 0, 1);
            return isDeletedByteBuffer.array()[0] == 48;
        }

        private int getMetaLength(byte[] valueObjectSerialized) {
            ByteBuffer metaLengthByteBuffer = ByteBuffer.wrap(valueObjectSerialized, 1, 4);
            int ret = metaLengthByteBuffer.getInt(metaLengthByteBuffer.position());
            return ret;
        }

        private void checkValueMapSerializerVersionFormat() {
            if (ByteBufferUtil.toInt(ByteBuffer.wrap(Arrays.copyOfRange(CURRENT_VALUEMAP_VERSION_FLAG, 1, 5))) != 900000000 || CURRENT_VALUEMAP_VERSION_FLAG[0] != 56 || CURRENT_VALUEMAP_VERSION_FLAG.length != 5 || 5 != CURRENT_VALUEMAP_VERSION_FLAG.length) {
                throw new RuntimeException("ValueMapSerializer version format is not illegal!");
            }
        }
    }

    public static class InvokeIdentifyOfSettingFullRecordValue {
        private InvokeIdentifyOfSettingFullRecordValue() {
        }
    }
}

