/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.midlayer.common;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import org.apache.cassandra.extend.midlayer.common.Constants;
import org.apache.cassandra.extend.midlayer.utils.ByteBufferUtil;

public class ValueMetas {
    private String blobMD5;
    private byte[] recordProperties;
    private int blobSize = -1;
    private long blobSumSizeInRecord = -1L;
    private ValueMetasProtector dataProtector = null;
    private CovertedString recordPropertiesCovertedString = new CovertedString(ByteBuffer.wrap("".getBytes()));

    private ValueMetas(String blobMD5, int blobSize, byte[] recordProperties, boolean checkBlobSize) {
        this.blobMD5 = blobMD5;
        this.blobSize = blobSize;
        this.recordProperties = recordProperties;
        if (checkBlobSize && blobSize < 0) {
            throw new RuntimeException("blob size must be more than 0!");
        }
    }

    public ValueMetas(String blobMD5, int blobSize, byte[] recordProperties) {
        this(blobMD5, blobSize, recordProperties, true);
    }

    public ValueMetas(String blobMD5, int blobSize, byte[] recordProperties, CovertedString recordPropertiesCovertedString) {
        this(blobMD5, blobSize, recordProperties);
        this.recordPropertiesCovertedString = recordPropertiesCovertedString;
    }

    public static ValueMetas createValueMetasForDeleting(ValueMetasProtector dataProtector) {
        ValueMetas ret = new ValueMetas("d41d8cd98f00b204e9800998ecf8427e", Integer.MIN_VALUE, null, false);
        ret.dataProtector = dataProtector;
        return ret;
    }

    public boolean isForDeleting() {
        return "d41d8cd98f00b204e9800998ecf8427e".equals(this.blobMD5) && this.blobSize == Integer.MIN_VALUE;
    }

    public static ValueMetas createEmptyValueMetas(ValueMetasProtector dataProtector) {
        ValueMetas ret = new ValueMetas("d41d8cd98f00b204e9800998ecf8427e", 0, null);
        ret.dataProtector = dataProtector;
        return ret;
    }

    public String getBlobMD5() {
        return this.blobMD5;
    }

    public byte[] getRecordProperties() {
        return this.recordProperties;
    }

    public int getBlobSize() {
        return this.blobSize;
    }

    public void setDataProtector(ValueMetasProtector dataProtector) {
        this.dataProtector = dataProtector;
    }

    public ValueMetasProtectorWrapper getValueMetasProtectorWrapper() {
        return new ValueMetasProtectorWrapper(this.dataProtector);
    }

    public long getBlobSumSizeInRecord() {
        return this.blobSumSizeInRecord;
    }

    public void setBlobSumSizeInRecord(long blobSumSizeInRecord) {
        this.blobSumSizeInRecord = blobSumSizeInRecord;
    }

    public CovertedString getRecordPropertiesCovertedString() {
        return this.recordPropertiesCovertedString;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ValueMetas)) {
            return false;
        }
        ValueMetas valueMetas2 = (ValueMetas)o;
        return this.blobMD5.equals(valueMetas2.blobMD5) && this.blobSize == valueMetas2.blobSize && Arrays.equals(this.recordProperties, valueMetas2.recordProperties);
    }

    public static class CovertedString {
        private String result = null;
        private boolean isLating = false;
        private byte[] tmpKeepingOriginalRecordProperties;

        public CovertedString(ByteBuffer byteBufferTobeCoverted) {
            byteBufferTobeCoverted = byteBufferTobeCoverted.duplicate();
            this.tmpKeepingOriginalRecordProperties = new byte[byteBufferTobeCoverted.remaining()];
            byteBufferTobeCoverted.duplicate().get(this.tmpKeepingOriginalRecordProperties, byteBufferTobeCoverted.arrayOffset(), byteBufferTobeCoverted.remaining());
            try {
                this.result = ByteBufferUtil.string(byteBufferTobeCoverted, Constants.UTF_8);
                String isoCovertedString = ByteBufferUtil.string(byteBufferTobeCoverted, Constants.ISO);
                this.isLating = this.result.equals(isoCovertedString) && this.result.length() == byteBufferTobeCoverted.remaining();
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.result;
        }

        public boolean isLating() {
            return this.isLating;
        }

        public boolean failedToConvert() {
            return this.result == null;
        }

        public byte[] getTmpKeepingOriginalRecordProperties() {
            return this.tmpKeepingOriginalRecordProperties;
        }

        public String putOutSomeNotLatinChars() {
            String ret = "";
            if (!this.isLating && this.result != null) {
                for (char ch : this.result.toCharArray()) {
                    if (Character.UnicodeBlock.BASIC_LATIN.equals(Character.UnicodeBlock.of(ch)) || ret.length() >= 5) continue;
                    ret = ret + ch;
                }
            }
            return ret;
        }
    }

    public static class ValueMetasProtectorWrapper {
        private ValueMetasProtector dataProtector;

        public ValueMetasProtectorWrapper(ValueMetasProtector dataProtector) {
            this.dataProtector = dataProtector;
        }

        public boolean theSmameAsByTheCore(ValueMetasProtectorWrapper o) {
            if (o == null) {
                return false;
            }
            return this.dataProtector == o.dataProtector;
        }

        public boolean coreIsNull() {
            return this.dataProtector == null;
        }
    }

    public static class ValueMetasProtector {
    }
}

