/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.monitor.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.extend.client.SimpleCondition;
import org.apache.cassandra.extend.monitor.mbean.ServiceNotificationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AExecuterForThreadSync
implements Runnable {
    private static Logger logger_ = LoggerFactory.getLogger(AExecuterForThreadSync.class);
    private SimpleCondition sc = new SimpleCondition();
    private long startTime = System.currentTimeMillis();
    private long timeout = 300000L;
    private Object result;
    private Exception executeError;

    public AExecuterForThreadSync(long timeout) {
        this.timeout = timeout;
    }

    public abstract Object execute() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.result = this.execute();
        }
        catch (Exception e) {
            this.executeError = e;
            logger_.error("AExecuterForJmxReadOrWriteFromBDB execute error", (Throwable)e);
        }
        finally {
            this.sc.signal();
        }
    }

    public void waitForExecuteComplete() throws ServiceNotificationException {
        boolean success;
        try {
            long time = this.timeout - (System.currentTimeMillis() - this.startTime);
            success = this.sc.await(time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger_.error("wait Thread waitForExecuteComplete error", (Throwable)e);
            success = false;
        }
        if (this.executeError != null) {
            throw new ServiceNotificationException(this.executeError.getMessage(), this.executeError);
        }
        if (!success) {
            throw new ServiceNotificationException("ServiceNotificationException execute timeout or jmx closed");
        }
    }

    public Object getResult() {
        return this.result;
    }
}

