/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.extend.monitor.mbean;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StatisticsTableSizeDTO
implements Serializable {
    private static final long serialVersionUID = -1405168344108759709L;
    private long loadTime;
    private long blockSize;
    private long blockMetaSize;
    private Map<String, Long> databaseSize = new HashMap<String, Long>();
    private Map<String, Long> databaseBlockCount = new HashMap<String, Long>();
    private Map<String, Long> tableSize = new HashMap<String, Long>();
    private Map<String, Long> tableBlockCount = new HashMap<String, Long>();

    public StatisticsTableSizeDTO() {
        this.loadTime = System.currentTimeMillis();
    }

    public Map<String, Long> getDatabaseSize() {
        return this.databaseSize;
    }

    public Map<String, Long> getTableSize() {
        return this.tableSize;
    }

    public Map<String, Long> getDatabaseBlockCount() {
        return this.databaseBlockCount;
    }

    public Map<String, Long> getTableBlockCount() {
        return this.tableBlockCount;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public long getBlockMetaSize() {
        return this.blockMetaSize;
    }

    public void setBlockMetaSize(long blockMetaSize) {
        this.blockMetaSize = blockMetaSize;
    }

    public void multipleResult(int multiple) {
        HashMap<String, Long> databaseBlockCountMultipled = new HashMap<String, Long>();
        for (String key : this.databaseBlockCount.keySet()) {
            databaseBlockCountMultipled.put(key, this.databaseBlockCount.get(key) * (long)multiple);
        }
        this.databaseBlockCount = databaseBlockCountMultipled;
        HashMap<String, Long> databaseSizeMultipled = new HashMap<String, Long>();
        for (String key : this.databaseSize.keySet()) {
            databaseSizeMultipled.put(key, this.databaseSize.get(key) * (long)multiple);
        }
        this.databaseSize = databaseSizeMultipled;
        HashMap<String, Long> tableBlockCountMultipled = new HashMap<String, Long>();
        for (String key : this.tableBlockCount.keySet()) {
            tableBlockCountMultipled.put(key, this.tableBlockCount.get(key) * (long)multiple);
        }
        this.tableBlockCount = tableBlockCountMultipled;
        HashMap<String, Long> tableSizeMultipled = new HashMap<String, Long>();
        for (String key : this.tableSize.keySet()) {
            tableSizeMultipled.put(key, this.tableSize.get(key) * (long)multiple);
        }
        this.tableSize = tableSizeMultipled;
    }

    public long sumBlockCount() {
        long sum = 0L;
        for (long count : this.databaseBlockCount.values()) {
            sum += count;
        }
        return sum;
    }

    public long sumBlockSize() {
        long sum = 0L;
        for (long count : this.databaseSize.values()) {
            sum += count;
        }
        return sum;
    }

    public void addSize(String database, String table, long size) {
        if (!this.databaseSize.containsKey(database)) {
            this.databaseSize.put(database, size);
            this.databaseBlockCount.put(database, 1L);
        } else {
            this.databaseSize.put(database, this.databaseSize.get(database) + size);
            this.databaseBlockCount.put(database, this.databaseBlockCount.get(database) + 1L);
        }
        String tableKey = database + '~' + table;
        if (!this.tableSize.containsKey(tableKey)) {
            this.tableSize.put(tableKey, size);
            this.tableBlockCount.put(tableKey, 1L);
        } else {
            this.tableSize.put(tableKey, this.tableSize.get(tableKey) + size);
            this.tableBlockCount.put(tableKey, this.tableBlockCount.get(tableKey) + 1L);
        }
    }

    public String toBlocksCheckText(String statType) {
        return String.format("statType:%s;block count by bdb:%s,block meta count by bdb:%s;block meta count by scan:%s,block size by scan:%s", statType, this.getBlockSize(), this.getBlockMetaSize(), this.sumBlockCount(), this.sumBlockSize());
    }
}

