/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.env;

import com.emc.mongoose.api.common.env.PathUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public abstract class Extensions {
    public static final String DIR_EXT = PathUtil.BASE_DIR + File.separator + "ext";
    public static final URLClassLoader CLS_LOADER;
    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(Extensions.class.getSimpleName());
        File dirExt = new File(DIR_EXT);
        if (!dirExt.exists() || !dirExt.isDirectory()) {
            CLS_LOADER = new URLClassLoader(new URL[0]);
            LOG.warning("No \"" + dirExt.getAbsolutePath() + "\" directory, loaded no extensions");
        } else {
            File[] extFiles = dirExt.listFiles();
            if (extFiles == null) {
                CLS_LOADER = new URLClassLoader(new URL[0]);
                LOG.warning("Failed to load the contents of the \"" + dirExt.getAbsolutePath() + "\" directory, loaded no extensions");
            } else {
                URL[] extFileUrls = new URL[extFiles.length];
                JarFile[] extFileJars = new JarFile[extFiles.length];
                for (int i = 0; i < extFiles.length; ++i) {
                    try {
                        extFileUrls[i] = extFiles[i].toURI().toURL();
                        LOG.config("Loading the extension from the file: \"" + extFiles[i] + "\"");
                        try {
                            extFileJars[i] = new JarFile(extFiles[i]);
                        }
                        catch (IOException e) {
                            LOG.warning("Failed to load the file \"" + extFiles[i] + "\", expected a valid JAR/ZIP file");
                        }
                        continue;
                    }
                    catch (MalformedURLException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                CLS_LOADER = new URLClassLoader(extFileUrls, ClassLoader.getSystemClassLoader());
            }
        }
    }
}

