/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.env;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class PathUtil {
    public static final String BASE_DIR = PathUtil.getBaseDir();

    private PathUtil() {
    }

    public static String getBaseDir() {
        return PathUtil.getBasePathForClass(PathUtil.class);
    }

    private static URI getBaseUriForClass(Class<?> cls) throws URISyntaxException {
        return cls.getProtectionDomain().getCodeSource().getLocation().toURI();
    }

    private static String getBasePathForClass(Class<?> cls) {
        try {
            File clsFile = new File(PathUtil.getBaseUriForClass(cls).getPath());
            File basePath = !clsFile.isDirectory() || clsFile.getPath().endsWith(".jar") || clsFile.getPath().endsWith(".zip") ? clsFile.getParentFile() : clsFile;
            String basePathStr = basePath.toString();
            if (basePathStr.endsWith(File.separator + "lib") || basePathStr.endsWith(File.separator + "bin") || basePathStr.endsWith("bin" + File.separator) || basePathStr.endsWith("lib" + File.separator)) {
                basePath = basePath.getParentFile();
            }
            if (basePathStr.endsWith(File.separator + "build" + File.separator + "classes")) {
                basePath = basePath.getParentFile().getParentFile();
            }
            if (basePathStr.endsWith(File.separator + "build" + File.separator + "classes" + File.separator + "java" + File.separator + "main")) {
                basePath = basePath.getParentFile().getParentFile().getParentFile().getParentFile();
            }
            if (basePathStr.endsWith(File.separator + "out" + File.separator + "production" + File.separator + "classes")) {
                basePath = basePath.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            }
            if (basePathStr.endsWith(File.separator + "build" + File.separator + "classes" + File.separator + "main")) {
                basePath = basePath.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
            }
            if (basePathStr.endsWith(File.separator + "build" + File.separator + "libs")) {
                basePath = basePath.getParentFile().getParentFile().getParentFile().getParentFile();
            }
            return basePath.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Cannot figure out base path for class: " + cls.getName());
        }
    }
}

