/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.PatternDefinedSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedSupplier;
import com.emc.mongoose.api.common.supply.StringSupplierFactory;
import com.emc.mongoose.api.common.supply.SupplierFactory;
import java.io.IOException;
import java.util.List;

public class BasicPatternDefinedSupplier
implements PatternDefinedSupplier {
    private static final ThreadLocal<StringBuilder> OUTPUT_BUILDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private final SupplierFactory<String, ? extends BatchSupplier<String>> supplierFactory;
    private final String pattern;
    private BatchSupplier<String>[] suppliers;
    private static final ThreadLocal<StringBuilder> STRING_BULDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected final StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public BasicPatternDefinedSupplier(String pattern) throws OmgShootMyFootException {
        this(pattern, StringSupplierFactory.getInstance());
    }

    public BasicPatternDefinedSupplier(String pattern, SupplierFactory<String, ? extends BatchSupplier<String>> supplierFactory) throws OmgShootMyFootException {
        if (pattern == null) {
            throw new OmgShootMyFootException("Null pattern");
        }
        this.supplierFactory = supplierFactory;
        this.pattern = pattern;
        this.initialize();
    }

    protected final SupplierFactory<String, ? extends BatchSupplier<String>> getSupplierFactory() {
        return this.supplierFactory;
    }

    @Override
    public final String getPattern() {
        return this.pattern;
    }

    protected final BatchSupplier<String>[] getSuppliers() {
        return this.suppliers;
    }

    protected final void setSuppliers(BatchSupplier<String>[] suppliers) {
        this.suppliers = suppliers;
    }

    protected void initialize() throws OmgShootMyFootException {
        if (this.pattern.charAt(0) != '%') {
            throw new OmgShootMyFootException();
        }
        StringBuilder patternBuilder = STRING_BULDER.get();
        patternBuilder.setLength(0);
        patternBuilder.append(this.pattern);
        patternBuilder.delete(0, 1);
        char type = patternBuilder.charAt(0);
        String formatStr = this.initParameter(patternBuilder, FORMAT_BRACKETS);
        String seedStr = this.initParameter(patternBuilder, RangeDefinedSupplier.SEED_BRACKETS);
        this.setSuppliers(new BatchSupplier[]{this.supplierFactory.createSupplier(type, seedStr, formatStr, null)});
    }

    protected final boolean isParameterPresented(StringBuilder expression, char[] binarySymbols) {
        return expression.length() >= 2 && expression.charAt(1) == binarySymbols[0];
    }

    protected final String getParameter(StringBuilder expression, char[] binarySymbols) {
        int closingSymbolPos = expression.indexOf(String.valueOf(binarySymbols[1]));
        String parameter = expression.substring(2, closingSymbolPos);
        expression.delete(1, closingSymbolPos + 1);
        return parameter;
    }

    protected final String initParameter(StringBuilder expression, char[] binarySymbols) {
        if (this.isParameterPresented(expression, binarySymbols)) {
            return this.getParameter(expression, binarySymbols);
        }
        return null;
    }

    protected String assembleOutputString(StringBuilder result) {
        return result.append((String)this.suppliers[0].get()).toString();
    }

    @Override
    public final String format(StringBuilder result) {
        if (this.suppliers == null) {
            return this.getPattern();
        }
        return this.assembleOutputString(result);
    }

    @Override
    public final String get() {
        StringBuilder result = OUTPUT_BUILDER.get();
        result.setLength(0);
        return this.format(result);
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        int count;
        StringBuilder result = OUTPUT_BUILDER.get();
        if (this.suppliers == null) {
            for (count = 0; count < limit; ++count) {
                result.setLength(0);
                buffer.add(this.pattern);
            }
        } else {
            while (count < limit) {
                result.setLength(0);
                buffer.add(this.assembleOutputString(result));
                ++count;
            }
        }
        return count;
    }

    @Override
    public final long skip(long count) {
        if (this.suppliers != null) {
            for (int i = 0; i < this.suppliers.length; ++i) {
                this.suppliers[i].skip(count);
            }
        }
        return count;
    }

    @Override
    public final void reset() {
        if (this.suppliers != null) {
            for (int i = 0; i < this.suppliers.length; ++i) {
                this.suppliers[i].reset();
            }
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.suppliers != null) {
            for (int i = 0; i < this.suppliers.length; ++i) {
                this.suppliers[i].close();
                this.suppliers[i] = null;
            }
            this.suppliers = null;
        }
    }
}

