/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.BatchSupplier;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;

public class BasicUpdatingValueSupplier<T>
implements BatchSupplier<T> {
    protected final T initialValue;
    protected volatile T lastValue = null;
    private Callable<T> updateAction;

    public BasicUpdatingValueSupplier(T initialValue, Callable<T> updateAction) {
        this.initialValue = initialValue;
        this.updateAction = updateAction;
        this.reset();
    }

    @Override
    public T get() {
        T prevValue = this.lastValue;
        try {
            this.lastValue = this.updateAction.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return prevValue;
    }

    @Override
    public int get(List<T> buffer, int limit) {
        int count;
        try {
            for (count = 0; count < limit; ++count) {
                buffer.add(this.lastValue);
                this.lastValue = this.updateAction.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return count;
    }

    @Override
    public long skip(long count) {
        try {
            int i = 0;
            while ((long)i < count) {
                this.lastValue = this.updateAction.call();
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return count;
    }

    @Override
    public void reset() {
        this.lastValue = this.initialValue;
    }

    @Override
    public void close() throws IOException {
        this.lastValue = null;
        this.updateAction = null;
    }
}

