/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.github.akurilov.commons.math.Random;
import java.io.File;
import java.util.List;

public class FilePathSupplier
implements BatchSupplier<String> {
    private static final int RADIX = 36;
    private final Random rnd;
    private final int width;
    private final int depth;
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL_PATH_BUILDER = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    public FilePathSupplier(long seed, String paramsString) {
        this(seed, FilePathSupplier.areParamsValid(paramsString) ? paramsString.split(";") : new String[]{});
    }

    private FilePathSupplier(long seed, String[] params) {
        this(seed, params.length > 0 ? Integer.parseInt(params[0].replaceAll(" ", "")) : 0, params.length > 1 ? Integer.parseInt(params[1].replaceAll(" ", "")) : 0);
    }

    public FilePathSupplier(long seed, int width, int depth) {
        this.rnd = new Random(seed);
        this.width = width;
        this.depth = depth;
        if (width <= 0 || depth <= 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final String get() {
        StringBuilder pathBuilder = THREAD_LOCAL_PATH_BUILDER.get();
        pathBuilder.setLength(0);
        int newDepth = this.rnd.nextInt(this.depth) + 1;
        for (int i = 0; i < newDepth; ++i) {
            pathBuilder.append(this.nextDirName(this.width));
            pathBuilder.append(File.separatorChar);
        }
        return pathBuilder.toString();
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        int count;
        StringBuilder pathBuilder = THREAD_LOCAL_PATH_BUILDER.get();
        for (count = 0; count < limit; ++count) {
            pathBuilder.setLength(0);
            int newDepth = this.rnd.nextInt(this.depth) + 1;
            for (int i = 0; i < newDepth; ++i) {
                pathBuilder.append(this.nextDirName(this.width));
                pathBuilder.append(File.separatorChar);
            }
            buffer.add(pathBuilder.toString());
        }
        return count;
    }

    @Override
    public final long skip(long count) {
        for (long i = 0L; i < count; ++i) {
            this.rnd.nextInt(this.depth);
        }
        return count;
    }

    @Override
    public final void reset() {
        this.rnd.reset();
    }

    @Override
    public final void close() {
    }

    private static boolean areParamsValid(String paramsString) {
        int delPos = paramsString == null ? 0 : paramsString.indexOf(";");
        return delPos > 0 && delPos < paramsString.length() - 1;
    }

    private String nextDirName(int width) {
        return Integer.toString(Math.abs(this.rnd.nextInt(width)), 36);
    }
}

