/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply.async;

import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.supply.async.AsyncRangeDefinedSupplierBase;
import com.github.akurilov.coroutines.CoroutinesProcessor;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class AsyncRangeDefinedDoubleFormattingSupplier
extends AsyncRangeDefinedSupplierBase<Double> {
    private final NumberFormat format;

    public AsyncRangeDefinedDoubleFormattingSupplier(CoroutinesProcessor coroutinesProcessor, long seed, double minValue, double maxValue, String formatString) throws OmgDoesNotPerformException {
        super(coroutinesProcessor, seed, minValue, maxValue);
        this.format = formatString == null || formatString.isEmpty() ? null : new DecimalFormat(formatString);
    }

    @Override
    protected final Double computeRange(Double minValue, Double maxValue) {
        return maxValue - minValue;
    }

    @Override
    protected final Double rangeValue() {
        return (Double)this.minValue() + this.rnd.nextDouble() * (Double)this.range();
    }

    @Override
    protected final Double singleValue() {
        return this.rnd.nextDouble();
    }

    @Override
    protected final String toString(Double value) {
        return this.format == null ? value.toString() : this.format.format(value);
    }
}

