/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply.async;

import com.emc.mongoose.api.common.exception.OmgShootMyFootException;
import com.emc.mongoose.api.common.supply.BatchSupplier;
import com.emc.mongoose.api.common.supply.SupplierFactory;
import com.emc.mongoose.api.common.supply.async.AsyncRangeDefinedDateFormattingSupplier;
import com.emc.mongoose.api.common.supply.async.AsyncRangeDefinedDoubleFormattingSupplier;
import com.emc.mongoose.api.common.supply.async.AsyncRangeDefinedLongFormattingSupplier;
import com.github.akurilov.coroutines.CoroutinesProcessor;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import org.apache.commons.lang.time.DateUtils;

public final class AsyncStringSupplierFactory<G extends BatchSupplier<String>>
implements SupplierFactory<String, G> {
    private static final AsyncStringSupplierFactory<? extends BatchSupplier<String>> INSTANCE = new AsyncStringSupplierFactory();
    private CoroutinesProcessor coroutinesProcessor;

    private AsyncStringSupplierFactory() {
    }

    public static AsyncStringSupplierFactory<? extends BatchSupplier<String>> getInstance(CoroutinesProcessor coroutinesProcessor) {
        return super.setCoroutinesProcessor(coroutinesProcessor);
    }

    private AsyncStringSupplierFactory<? extends BatchSupplier<String>> setCoroutinesProcessor(CoroutinesProcessor coroutinesProcessor) {
        this.coroutinesProcessor = coroutinesProcessor;
        return this;
    }

    @Override
    public final G createSupplier(char type, String seedStr, String formatStr, String rangeStr) throws OmgShootMyFootException {
        long seed = System.nanoTime() ^ System.currentTimeMillis();
        if (seedStr != null && !seedStr.isEmpty()) {
            try {
                seed = Long.parseLong(seedStr);
            }
            catch (NumberFormatException e) {
                throw new OmgShootMyFootException("Seed value is not a 64 bit integer: \"" + seedStr + "\"");
            }
        }
        switch (type) {
            case 'd': {
                long min = Long.MIN_VALUE;
                long max = Long.MAX_VALUE;
                if (rangeStr != null && !rangeStr.isEmpty()) {
                    Matcher matcher = LONG_PATTERN.matcher(rangeStr);
                    if (matcher.find()) {
                        min = Long.parseLong(matcher.group(1));
                        max = Long.parseLong(matcher.group(2));
                    } else {
                        throw new OmgShootMyFootException();
                    }
                }
                return (G)new AsyncRangeDefinedLongFormattingSupplier(this.coroutinesProcessor, seed, min, max, formatStr);
            }
            case 'f': {
                double min = 0.0;
                double max = 1.0;
                if (rangeStr != null && !rangeStr.isEmpty()) {
                    Matcher matcher = DOUBLE_PATTERN.matcher(rangeStr);
                    if (matcher.find()) {
                        min = Double.parseDouble(matcher.group(1));
                        max = Double.parseDouble(matcher.group(2));
                    } else {
                        throw new OmgShootMyFootException();
                    }
                }
                return (G)new AsyncRangeDefinedDoubleFormattingSupplier(this.coroutinesProcessor, seed, min, max, formatStr);
            }
            case 'D': {
                Date min = new Date(0L);
                Date max = new Date();
                if (rangeStr != null && !rangeStr.isEmpty()) {
                    Matcher matcher = DATE_PATTERN.matcher(rangeStr);
                    if (matcher.find()) {
                        try {
                            min = DateUtils.parseDate((String)matcher.group(1), (String[])INPUT_DATE_FMT_STRINGS);
                            max = DateUtils.parseDate((String)matcher.group(6), (String[])INPUT_DATE_FMT_STRINGS);
                        }
                        catch (ParseException e) {
                            throw new OmgShootMyFootException("Failed to parse the pattern");
                        }
                    } else {
                        throw new OmgShootMyFootException();
                    }
                }
                return (G)new AsyncRangeDefinedDateFormattingSupplier(this.coroutinesProcessor, seed, min, max, formatStr);
            }
        }
        throw new OmgShootMyFootException("Unknown format type: '" + type + "'");
    }
}

