/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.math;

public class FloatConversions {
    static short bFloat16NaN = (short)32641;
    private static final short SIGN_MASK = Short.MIN_VALUE;
    private static final short EXP_MASK = 31744;
    private static final short NAN_VALUE = Short.MAX_VALUE;

    public static float bFloat16ToFloat32(short raw) {
        return Float.intBitsToFloat(raw << 16);
    }

    public static short float32ToBFloat16(float n) {
        int nbits = Float.floatToRawIntBits(n);
        int s = nbits >>> 16 & 0x8000;
        int e = nbits >>> 16 & 0x7F80;
        int m = nbits & 0x7FFFFF;
        if (e != 32640) {
            int m1 = FloatConversions.round(m, 16);
            int e1 = e + m1;
            return (short)(s | e1);
        }
        return m != 0 ? bFloat16NaN : (short)(nbits >>> 16);
    }

    static int round(int m, int shifts) {
        int mid = 1 << shifts - 1;
        int mask = (1 << shifts) - 1;
        int mshift = m >> shifts;
        int masked = m & mask;
        int cmp = masked - mid;
        if (cmp > 0) {
            return mshift + 1;
        }
        if (cmp < 0) {
            return mshift;
        }
        boolean isOdd = (mshift & 1) != 0;
        return isOdd ? mshift + 1 : mshift;
    }

    public static float float16ToFloat32Alt(short raw) {
        long w = Integer.toUnsignedLong(raw << 16);
        long sign = w & 0x80000000L;
        long nonsign = w & Integer.MAX_VALUE;
        int renorm_shift = Long.numberOfLeadingZeros(nonsign);
        renorm_shift = renorm_shift > 37 ? renorm_shift - 37 : 0;
        long zero_mask = nonsign - 1L >> 63;
        return Float.intBitsToFloat((int)(sign | (nonsign << renorm_shift >> 3) + (long)(112 - renorm_shift << 23) & (zero_mask ^ 0xFFFFFFFFFFFFFFFFL)));
    }

    private static boolean IS_ZERO(short x) {
        return (x & Short.MAX_VALUE) == 0;
    }

    private static boolean IS_INVALID(short x) {
        return (x & 0x7C00) == 31744;
    }

    private static boolean IS_NAN(short x) {
        return (x & Short.MAX_VALUE) > 31744;
    }

    private static boolean IS_INF(short x) {
        return (x & Short.MAX_VALUE) == 31744;
    }

    private static short MANTISSA(short x) {
        return (short)(x & 0x3FF | ((x & 0x7C00) == 0 ? 0 : 1024));
    }

    private static short EXPONENT(short x) {
        return (short)((x & 0x7C00) >> 10);
    }

    private static short SIGNED_INF_VALUE(short x) {
        return (short)(x & Short.MIN_VALUE | 0x7C00);
    }

    public static short subIeeeFloat16(short a, short b) {
        if (((a ^ b) & 0x8000) != 0) {
            return FloatConversions.addIeeeFloat16(a, (short)(b ^ 0x8000));
        }
        short sign = (short)(a & 0x8000);
        if ((a = (short)(a << 1)) < (b = (short)(b << 1))) {
            short x = a;
            a = b;
            b = x;
            sign = (short)(sign ^ 0x8000);
        }
        short ax = (short)(a & 0xF800);
        short bx = (short)(b & 0xF800);
        if (a >= 63488 || b >= 63488) {
            if (a > 63488 || b > 63488 || a == b) {
                return Short.MAX_VALUE;
            }
            short res = (short)(sign | 0x7C00);
            if (a == 63488) {
                return res;
            }
            return (short)(res ^ 0x8000);
        }
        int exp_diff = ax - bx;
        short exp_part = ax;
        if (exp_diff != 0) {
            int shift = exp_diff >> 11;
            b = bx != 0 ? (short)((b & 0x7FF | 0x800) >> shift) : (short)(b >> shift - 1);
        } else {
            if (bx == 0) {
                short res = (short)(a - b >> 1);
                if (res == 0) {
                    return res;
                }
                return (short)(res | sign);
            }
            b = (short)(b & 0x7FF | 0x800);
        }
        short r = (short)(a - b);
        if ((r & 0xF800) == exp_part) {
            return (short)(r >> 1 | sign);
        }
        short am = (short)(a & 0x7FF | 0x800);
        short new_m = (short)(am - b);
        if (new_m == 0) {
            return 0;
        }
        while (exp_part != 0 && (new_m & 0x800) == 0) {
            if ((exp_part = (short)(exp_part - 2048)) == 0) continue;
            new_m = (short)(new_m << 1);
        }
        return (short)((new_m & 0x7FF | exp_part) >> 1 | sign);
    }

    public static short addIeeeFloat16(short a, short b) {
        if (((a ^ b) & 0x8000) != 0) {
            return FloatConversions.subIeeeFloat16(a, (short)(b ^ 0x8000));
        }
        short sign = (short)(a & 0x8000);
        if ((a = (short)(a & Short.MAX_VALUE)) < (b = (short)(b & Short.MAX_VALUE))) {
            short x = a;
            a = b;
            b = x;
        }
        if (a >= 31744 || b >= 31744) {
            if (a > 31744 || b > 31744) {
                return Short.MAX_VALUE;
            }
            return (short)(0x7C00 | sign);
        }
        short ax = (short)(a & 0x7C00);
        short bx = (short)(b & 0x7C00);
        short exp_diff = (short)(ax - bx);
        short exp_part = ax;
        if (exp_diff != 0) {
            short shift = (short)(exp_diff >> 10);
            b = bx != 0 ? (short)((b & 0x3FF | 0x400) >> shift) : (short)(b >> shift - 1);
        } else {
            if (bx == 0) {
                return (short)(a + b | sign);
            }
            b = (short)(b & 0x3FF | 0x400);
        }
        short r = (short)(a + b);
        if ((r & 0x7C00) != exp_part) {
            short am = (short)(a & 0x3FF | 0x400);
            short new_m = (short)(am + b >> 1);
            r = (short)(exp_part + 1024 | 0x3FF & new_m);
        }
        if ((r & 0xFFFF) >= 31744) {
            return (short)(sign | 0x7C00);
        }
        return (short)(r | sign);
    }

    public static short mulIeeeFloat16(short a, short b) {
        int sign = (a ^ b) & Short.MIN_VALUE;
        if (FloatConversions.IS_INVALID(a) || FloatConversions.IS_INVALID(b)) {
            if (FloatConversions.IS_NAN(a) || FloatConversions.IS_NAN(b) || FloatConversions.IS_ZERO(a) || FloatConversions.IS_ZERO(b)) {
                return Short.MAX_VALUE;
            }
            return (short)(sign | 0x7C00);
        }
        if (FloatConversions.IS_ZERO(a) || FloatConversions.IS_ZERO(b)) {
            return 0;
        }
        short m1 = FloatConversions.MANTISSA(a);
        short m2 = FloatConversions.MANTISSA(b);
        long v = m1;
        int ax = FloatConversions.EXPONENT(a);
        int bx = FloatConversions.EXPONENT(b);
        int new_exp = (ax += ax == 0 ? (short)1 : 0) + (bx += bx == 0 ? (short)1 : 0) - 15;
        if (((v *= (long)m2) & 0x200000L) != 0L) {
            v >>= 11;
            ++new_exp;
        } else if ((v & 0x100000L) != 0L) {
            v >>= 10;
        } else {
            new_exp -= 10;
            while (v >= 2048L) {
                v >>= 1;
                ++new_exp;
            }
        }
        if (new_exp <= 0) {
            v >>= -new_exp + 1;
            new_exp = 0;
        } else if (new_exp >= 31) {
            return FloatConversions.SIGNED_INF_VALUE((short)sign);
        }
        return (short)((long)(sign | new_exp << 10) | v & 0x3FFL);
    }
}

