/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class JsonSupport {
    public static final ObjectMapper om = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_MISSING_CREATOR_PROPERTIES, false).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});

    public static String toJson(Object o) {
        try {
            return om.writer((PrettyPrinter)JlamaPrettyPrinter.INSTANCE).writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> extractJsonFromString(String s) {
        JsonFactory factory = new JsonFactory();
        String text = s;
        ArrayList<String> jsons = new ArrayList<String>();
        while (text != null && !text.isEmpty()) {
            boolean found = false;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '{' && text.charAt(i) != '[') continue;
                String possibleJson = text.substring(i);
                try (JsonParser parser = factory.createParser((Reader)new StringReader(possibleJson));){
                    JsonToken token = parser.nextToken();
                    if (token == null) continue;
                    parser.skipChildren();
                    int endIndex = i + (int)parser.getTokenLocation().getCharOffset();
                    int extra = 0;
                    while (endIndex + extra < text.length() && (text.charAt(endIndex + extra) == '}' || text.charAt(endIndex + extra) == ']')) {
                        ++extra;
                    }
                    String jsonString = text.substring(i, endIndex + extra);
                    jsons.add(jsonString);
                    found = true;
                    text = text.substring(endIndex + extra);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (found) continue;
            break;
        }
        return jsons;
    }

    public static class JlamaPrettyPrinter
    extends DefaultPrettyPrinter {
        public static final JlamaPrettyPrinter INSTANCE = new JlamaPrettyPrinter();

        public DefaultPrettyPrinter createInstance() {
            return INSTANCE;
        }

        private JlamaPrettyPrinter() {
            this._objectIndenter = DefaultPrettyPrinter.FixedSpaceIndenter.instance;
            this._spacesInObjectEntries = false;
        }

        public void beforeArrayValues(JsonGenerator jg) {
        }

        public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException {
            if (!this._arrayIndenter.isInline()) {
                --this._nesting;
            }
            jg.writeRaw(']');
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException {
            jg.writeRaw(": ");
        }

        public void beforeObjectEntries(JsonGenerator jg) {
        }

        public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException {
            if (!this._objectIndenter.isInline()) {
                --this._nesting;
            }
            jg.writeRaw("}");
        }
    }
}

