/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelMonitorName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MODEL_MONITOR = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/modelMonitors/{model_monitor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String modelMonitor;

    @Deprecated
    protected ModelMonitorName() {
        this.project = null;
        this.location = null;
        this.modelMonitor = null;
    }

    private ModelMonitorName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.modelMonitor = (String)Preconditions.checkNotNull((Object)builder.getModelMonitor());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModelMonitor() {
        return this.modelMonitor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ModelMonitorName of(String project, String location, String modelMonitor) {
        return ModelMonitorName.newBuilder().setProject(project).setLocation(location).setModelMonitor(modelMonitor).build();
    }

    public static String format(String project, String location, String modelMonitor) {
        return ModelMonitorName.newBuilder().setProject(project).setLocation(location).setModelMonitor(modelMonitor).build().toString();
    }

    public static ModelMonitorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MODEL_MONITOR.validatedMatch(formattedString, "ModelMonitorName.parse: formattedString not in valid format");
        return ModelMonitorName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model_monitor"));
    }

    public static List<ModelMonitorName> parseList(List<String> formattedStrings) {
        ArrayList<ModelMonitorName> list = new ArrayList<ModelMonitorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelMonitorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelMonitorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelMonitorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MODEL_MONITOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelMonitorName modelMonitorName = this;
            synchronized (modelMonitorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.modelMonitor != null) {
                        fieldMapBuilder.put((Object)"model_monitor", (Object)this.modelMonitor);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MODEL_MONITOR.instantiate(new String[]{"project", this.project, "location", this.location, "model_monitor", this.modelMonitor});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ModelMonitorName that = (ModelMonitorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.modelMonitor, that.modelMonitor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.modelMonitor);
    }

    public static class Builder {
        private String project;
        private String location;
        private String modelMonitor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModelMonitor() {
            return this.modelMonitor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModelMonitor(String modelMonitor) {
            this.modelMonitor = modelMonitor;
            return this;
        }

        private Builder(ModelMonitorName modelMonitorName) {
            this.project = modelMonitorName.project;
            this.location = modelMonitorName.location;
            this.modelMonitor = modelMonitorName.modelMonitor;
        }

        public ModelMonitorName build() {
            return new ModelMonitorName(this);
        }
    }
}

