/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserStoreName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_USER_STORE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/userStores/{user_store}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String userStore;

    @Deprecated
    protected UserStoreName() {
        this.project = null;
        this.location = null;
        this.userStore = null;
    }

    private UserStoreName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.userStore = (String)Preconditions.checkNotNull((Object)builder.getUserStore());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getUserStore() {
        return this.userStore;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static UserStoreName of(String project, String location, String userStore) {
        return UserStoreName.newBuilder().setProject(project).setLocation(location).setUserStore(userStore).build();
    }

    public static String format(String project, String location, String userStore) {
        return UserStoreName.newBuilder().setProject(project).setLocation(location).setUserStore(userStore).build().toString();
    }

    public static UserStoreName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_USER_STORE.validatedMatch(formattedString, "UserStoreName.parse: formattedString not in valid format");
        return UserStoreName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("user_store"));
    }

    public static List<UserStoreName> parseList(List<String> formattedStrings) {
        ArrayList<UserStoreName> list = new ArrayList<UserStoreName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UserStoreName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UserStoreName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UserStoreName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_USER_STORE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            UserStoreName userStoreName = this;
            synchronized (userStoreName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.userStore != null) {
                        fieldMapBuilder.put((Object)"user_store", (Object)this.userStore);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_USER_STORE.instantiate(new String[]{"project", this.project, "location", this.location, "user_store", this.userStore});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            UserStoreName that = (UserStoreName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.userStore, that.userStore);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.userStore);
    }

    public static class Builder {
        private String project;
        private String location;
        private String userStore;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getUserStore() {
            return this.userStore;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setUserStore(String userStore) {
            this.userStore = userStore;
            return this;
        }

        private Builder(UserStoreName userStoreName) {
            this.project = userStoreName.project;
            this.location = userStoreName.location;
            this.userStore = userStoreName.userStore;
        }

        public UserStoreName build() {
            return new UserStoreName(this);
        }
    }
}

