/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.CreateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteIndexRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.GetIndexRequest;
import com.google.cloud.aiplatform.v1beta1.Index;
import com.google.cloud.aiplatform.v1beta1.IndexServiceClient;
import com.google.cloud.aiplatform.v1beta1.ListIndexesRequest;
import com.google.cloud.aiplatform.v1beta1.ListIndexesResponse;
import com.google.cloud.aiplatform.v1beta1.RemoveDatapointsRequest;
import com.google.cloud.aiplatform.v1beta1.RemoveDatapointsResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.UpdateIndexRequest;
import com.google.cloud.aiplatform.v1beta1.UpsertDatapointsRequest;
import com.google.cloud.aiplatform.v1beta1.UpsertDatapointsResponse;
import com.google.cloud.aiplatform.v1beta1.stub.GrpcIndexServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.IndexServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class IndexServiceStubSettings
extends StubSettings<IndexServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings;
    private final OperationCallSettings<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationSettings;
    private final UnaryCallSettings<GetIndexRequest, Index> getIndexSettings;
    private final PagedCallSettings<ListIndexesRequest, ListIndexesResponse, IndexServiceClient.ListIndexesPagedResponse> listIndexesSettings;
    private final UnaryCallSettings<UpdateIndexRequest, Operation> updateIndexSettings;
    private final OperationCallSettings<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationSettings;
    private final UnaryCallSettings<DeleteIndexRequest, Operation> deleteIndexSettings;
    private final OperationCallSettings<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationSettings;
    private final UnaryCallSettings<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsSettings;
    private final UnaryCallSettings<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, IndexServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index> LIST_INDEXES_PAGE_STR_DESC = new PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index>(){

        public String emptyToken() {
            return "";
        }

        public ListIndexesRequest injectToken(ListIndexesRequest payload, String token) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageToken(token).build();
        }

        public ListIndexesRequest injectPageSize(ListIndexesRequest payload, int pageSize) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIndexesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIndexesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Index> extractResources(ListIndexesResponse payload) {
            return payload.getIndexesList() == null ? ImmutableList.of() : payload.getIndexesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, IndexServiceClient.ListIndexesPagedResponse> LIST_INDEXES_PAGE_STR_FACT = new PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, IndexServiceClient.ListIndexesPagedResponse>(){

        public ApiFuture<IndexServiceClient.ListIndexesPagedResponse> getFuturePagedResponse(UnaryCallable<ListIndexesRequest, ListIndexesResponse> callable, ListIndexesRequest request, ApiCallContext context, ApiFuture<ListIndexesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INDEXES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IndexServiceClient.ListIndexesPagedResponse.createAsync((PageContext<ListIndexesRequest, ListIndexesResponse, Index>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, IndexServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, IndexServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<IndexServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return IndexServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings() {
        return this.createIndexSettings;
    }

    public OperationCallSettings<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationSettings() {
        return this.createIndexOperationSettings;
    }

    public UnaryCallSettings<GetIndexRequest, Index> getIndexSettings() {
        return this.getIndexSettings;
    }

    public PagedCallSettings<ListIndexesRequest, ListIndexesResponse, IndexServiceClient.ListIndexesPagedResponse> listIndexesSettings() {
        return this.listIndexesSettings;
    }

    public UnaryCallSettings<UpdateIndexRequest, Operation> updateIndexSettings() {
        return this.updateIndexSettings;
    }

    public OperationCallSettings<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationSettings() {
        return this.updateIndexOperationSettings;
    }

    public UnaryCallSettings<DeleteIndexRequest, Operation> deleteIndexSettings() {
        return this.deleteIndexSettings;
    }

    public OperationCallSettings<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationSettings() {
        return this.deleteIndexOperationSettings;
    }

    public UnaryCallSettings<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsSettings() {
        return this.upsertDatapointsSettings;
    }

    public UnaryCallSettings<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsSettings() {
        return this.removeDatapointsSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, IndexServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public IndexServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcIndexServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "aiplatform";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "aiplatform.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "aiplatform.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return IndexServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(IndexServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected IndexServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createIndexSettings = settingsBuilder.createIndexSettings().build();
        this.createIndexOperationSettings = settingsBuilder.createIndexOperationSettings().build();
        this.getIndexSettings = settingsBuilder.getIndexSettings().build();
        this.listIndexesSettings = settingsBuilder.listIndexesSettings().build();
        this.updateIndexSettings = settingsBuilder.updateIndexSettings().build();
        this.updateIndexOperationSettings = settingsBuilder.updateIndexOperationSettings().build();
        this.deleteIndexSettings = settingsBuilder.deleteIndexSettings().build();
        this.deleteIndexOperationSettings = settingsBuilder.deleteIndexOperationSettings().build();
        this.upsertDatapointsSettings = settingsBuilder.upsertDatapointsSettings().build();
        this.removeDatapointsSettings = settingsBuilder.removeDatapointsSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<IndexServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings;
        private final OperationCallSettings.Builder<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationSettings;
        private final UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings;
        private final PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, IndexServiceClient.ListIndexesPagedResponse> listIndexesSettings;
        private final UnaryCallSettings.Builder<UpdateIndexRequest, Operation> updateIndexSettings;
        private final OperationCallSettings.Builder<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationSettings;
        private final UnaryCallSettings.Builder<DeleteIndexRequest, Operation> deleteIndexSettings;
        private final OperationCallSettings.Builder<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationSettings;
        private final UnaryCallSettings.Builder<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsSettings;
        private final UnaryCallSettings.Builder<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, IndexServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createIndexOperationSettings = OperationCallSettings.newBuilder();
            this.getIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listIndexesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INDEXES_PAGE_STR_FACT);
            this.updateIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateIndexOperationSettings = OperationCallSettings.newBuilder();
            this.deleteIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexOperationSettings = OperationCallSettings.newBuilder();
            this.upsertDatapointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeDatapointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexSettings, this.getIndexSettings, this.listIndexesSettings, this.updateIndexSettings, this.deleteIndexSettings, this.upsertDatapointsSettings, this.removeDatapointsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(IndexServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createIndexSettings = settings.createIndexSettings.toBuilder();
            this.createIndexOperationSettings = settings.createIndexOperationSettings.toBuilder();
            this.getIndexSettings = settings.getIndexSettings.toBuilder();
            this.listIndexesSettings = settings.listIndexesSettings.toBuilder();
            this.updateIndexSettings = settings.updateIndexSettings.toBuilder();
            this.updateIndexOperationSettings = settings.updateIndexOperationSettings.toBuilder();
            this.deleteIndexSettings = settings.deleteIndexSettings.toBuilder();
            this.deleteIndexOperationSettings = settings.deleteIndexOperationSettings.toBuilder();
            this.upsertDatapointsSettings = settings.upsertDatapointsSettings.toBuilder();
            this.removeDatapointsSettings = settings.removeDatapointsSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexSettings, this.getIndexSettings, this.listIndexesSettings, this.updateIndexSettings, this.deleteIndexSettings, this.upsertDatapointsSettings, this.removeDatapointsSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(IndexServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)IndexServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)IndexServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(IndexServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.getIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listIndexesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.updateIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.deleteIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.upsertDatapointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.removeDatapointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Index.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateIndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Index.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateIndexOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteIndexOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings() {
            return this.createIndexSettings;
        }

        public OperationCallSettings.Builder<CreateIndexRequest, Index, CreateIndexOperationMetadata> createIndexOperationSettings() {
            return this.createIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings() {
            return this.getIndexSettings;
        }

        public PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, IndexServiceClient.ListIndexesPagedResponse> listIndexesSettings() {
            return this.listIndexesSettings;
        }

        public UnaryCallSettings.Builder<UpdateIndexRequest, Operation> updateIndexSettings() {
            return this.updateIndexSettings;
        }

        public OperationCallSettings.Builder<UpdateIndexRequest, Index, UpdateIndexOperationMetadata> updateIndexOperationSettings() {
            return this.updateIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteIndexRequest, Operation> deleteIndexSettings() {
            return this.deleteIndexSettings;
        }

        public OperationCallSettings.Builder<DeleteIndexRequest, Empty, DeleteOperationMetadata> deleteIndexOperationSettings() {
            return this.deleteIndexOperationSettings;
        }

        public UnaryCallSettings.Builder<UpsertDatapointsRequest, UpsertDatapointsResponse> upsertDatapointsSettings() {
            return this.upsertDatapointsSettings;
        }

        public UnaryCallSettings.Builder<RemoveDatapointsRequest, RemoveDatapointsResponse> removeDatapointsSettings() {
            return this.removeDatapointsSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, IndexServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public IndexServiceStubSettings build() throws IOException {
            return new IndexServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

