/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.ServingConfig;
import com.google.cloud.discoveryengine.v1.ServingConfigServiceSettings;
import com.google.cloud.discoveryengine.v1.UpdateServingConfigRequest;
import com.google.cloud.discoveryengine.v1.stub.ServingConfigServiceStub;
import com.google.cloud.discoveryengine.v1.stub.ServingConfigServiceStubSettings;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ServingConfigServiceClient
implements BackgroundResource {
    private final ServingConfigServiceSettings settings;
    private final ServingConfigServiceStub stub;

    public static final ServingConfigServiceClient create() throws IOException {
        return ServingConfigServiceClient.create(ServingConfigServiceSettings.newBuilder().build());
    }

    public static final ServingConfigServiceClient create(ServingConfigServiceSettings settings) throws IOException {
        return new ServingConfigServiceClient(settings);
    }

    public static final ServingConfigServiceClient create(ServingConfigServiceStub stub) {
        return new ServingConfigServiceClient(stub);
    }

    protected ServingConfigServiceClient(ServingConfigServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServingConfigServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ServingConfigServiceClient(ServingConfigServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ServingConfigServiceSettings getSettings() {
        return this.settings;
    }

    public ServingConfigServiceStub getStub() {
        return this.stub;
    }

    public final ServingConfig updateServingConfig(ServingConfig servingConfig, FieldMask updateMask) {
        UpdateServingConfigRequest request = UpdateServingConfigRequest.newBuilder().setServingConfig(servingConfig).setUpdateMask(updateMask).build();
        return this.updateServingConfig(request);
    }

    public final ServingConfig updateServingConfig(UpdateServingConfigRequest request) {
        return (ServingConfig)this.updateServingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateServingConfigRequest, ServingConfig> updateServingConfigCallable() {
        return this.stub.updateServingConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

