/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.AbstractClient;
import com.obs.services.AbstractDeprecatedBucketClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCustomDomainInfo;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.DeleteBucketCustomDomainRequest;
import com.obs.services.model.GetBucketCustomDomainRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.RequestPaymentEnum;
import com.obs.services.model.SetBucketAclRequest;
import com.obs.services.model.SetBucketCorsRequest;
import com.obs.services.model.SetBucketCustomDomainRequest;
import com.obs.services.model.SetBucketLoggingRequest;
import com.obs.services.model.SetBucketQuotaRequest;
import com.obs.services.model.SetBucketRequestPaymentRequest;
import com.obs.services.model.SetBucketStoragePolicyRequest;
import com.obs.services.model.SetBucketVersioningRequest;
import java.util.List;

public abstract class AbstractBucketClient
extends AbstractDeprecatedBucketClient {
    @Override
    public ObsBucket createBucket(String bucketName) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(String bucketName, String location) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setLocation(location);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(ObsBucket bucket) throws ObsException {
        CreateBucketRequest request = new CreateBucketRequest();
        request.setBucketName(bucket.getBucketName());
        request.setAcl(bucket.getAcl());
        request.setBucketStorageClass(bucket.getBucketStorageClass());
        request.setLocation(bucket.getLocation());
        return this.createBucket(request);
    }

    @Override
    public ObsBucket createBucket(final CreateBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CreateBucketRequest is null");
        return this.doActionWithResult("createBucket", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<ObsBucket>(){

            @Override
            public ObsBucket action() throws ServiceException {
                if (AbstractBucketClient.this.isCname()) {
                    throw new ServiceException("createBucket is not allowed in customdomain mode");
                }
                try {
                    return AbstractBucketClient.this.createBucketImpl(request);
                }
                catch (ServiceException e) {
                    if (AbstractBucketClient.this.isAuthTypeNegotiation() && e.getResponseCode() == 400 && "Unsupported Authorization Type".equals(e.getErrorMessage()) && AbstractBucketClient.this.getProviderCredentials().getLocalAuthType(request.getBucketName()) == AuthTypeEnum.OBS) {
                        AbstractBucketClient.this.getProviderCredentials().setLocalAuthType(request.getBucketName(), AuthTypeEnum.V2);
                        return AbstractBucketClient.this.createBucketImpl(request);
                    }
                    throw e;
                }
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = AbstractBucketClient.this.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = AbstractBucketClient.this.getApiVersion("");
                    AbstractBucketClient.this.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public List<ObsBucket> listBuckets(ListBucketsRequest request) throws ObsException {
        return this.listBucketsV2(request).getBuckets();
    }

    @Override
    public ListBucketsResult listBucketsV2(final ListBucketsRequest request) throws ObsException {
        return this.doActionWithResult("listBuckets", "All Buckets", new AbstractClient.ActionCallbackWithResult<ListBucketsResult>(){

            @Override
            public ListBucketsResult action() throws ServiceException {
                if (AbstractBucketClient.this.isCname()) {
                    throw new ServiceException("listBuckets is not allowed in customdomain mode");
                }
                return AbstractBucketClient.this.listAllBucketsImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = AbstractBucketClient.this.getProviderCredentials().getLocalAuthType().get(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = AbstractBucketClient.this.getApiVersion("");
                    AbstractBucketClient.this.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                }
            }
        });
    }

    @Override
    public boolean headBucket(String bucketName) throws ObsException {
        return this.headBucket(new BaseBucketRequest(bucketName));
    }

    @Override
    public boolean headBucket(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("headBucket", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<Boolean>(){

            @Override
            public Boolean action() throws ServiceException {
                return AbstractBucketClient.this.headBucketImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                block3: {
                    try {
                        AuthTypeEnum authTypeEnum = AbstractBucketClient.this.getProviderCredentials().getLocalAuthType().get(bucketName);
                        if (authTypeEnum == null) {
                            authTypeEnum = AbstractBucketClient.this.getApiVersion(bucketName);
                            AbstractBucketClient.this.getProviderCredentials().setLocalAuthType(bucketName, authTypeEnum);
                        }
                    }
                    catch (ServiceException e) {
                        if (e.getResponseCode() == 404) break block3;
                        throw e;
                    }
                }
            }
        });
    }

    @Override
    public HeaderResponse deleteBucket(String bucketName) throws ObsException {
        return this.deleteBucket(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucket(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("deleteBucket", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.deleteBucketImpl(request);
            }
        });
    }

    @Override
    public BucketMetadataInfoResult getBucketMetadata(final BucketMetadataInfoRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BucketMetadataInfoRequest is null");
        return this.doActionWithResult("getBucketMetadata", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketMetadataInfoResult>(){

            @Override
            public BucketMetadataInfoResult action() throws ServiceException {
                return AbstractBucketClient.this.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws ObsException {
        return this.getBucketAcl(new BaseBucketRequest(bucketName));
    }

    @Override
    public AccessControlList getBucketAcl(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketAcl", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<AccessControlList>(){

            @Override
            public AccessControlList action() throws ServiceException {
                return AbstractBucketClient.this.getBucketAclImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketAcl(String bucketName, AccessControlList acl) throws ObsException {
        return this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public HeaderResponse setBucketAcl(final SetBucketAclRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketAclRequest is null");
        return this.doActionWithResult("setBucketAcl", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (request.getAcl() == null && null == request.getCannedACL()) {
                    throw new IllegalArgumentException("Both CannedACL and AccessControlList is null");
                }
                return AbstractBucketClient.this.setBucketAclImpl(request);
            }
        });
    }

    @Override
    public String getBucketLocation(String bucketName) throws ObsException {
        return this.getBucketLocation(new BaseBucketRequest(bucketName)).getLocation();
    }

    @Override
    public BucketLocationResponse getBucketLocation(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketLocation", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketLocationResponse>(){

            @Override
            public BucketLocationResponse action() throws ServiceException {
                return AbstractBucketClient.this.getBucketLocationImpl(request);
            }
        });
    }

    @Override
    public BucketLocationResponse getBucketLocationV2(String bucketName) throws ObsException {
        return this.getBucketLocation(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(String bucketName) throws ObsException {
        return this.getBucketStorageInfo(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketStorageInfo", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketStorageInfo>(){

            @Override
            public BucketStorageInfo action() throws ServiceException {
                return AbstractBucketClient.this.getBucketStorageInfoImpl(request);
            }
        });
    }

    @Override
    public BucketQuota getBucketQuota(String bucketName) throws ObsException {
        return this.getBucketQuota(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketQuota getBucketQuota(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketQuota", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketQuota>(){

            @Override
            public BucketQuota action() throws ServiceException {
                return AbstractBucketClient.this.getBucketQuotaImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketQuota(String bucketName, BucketQuota bucketQuota) throws ObsException {
        return this.setBucketQuota(new SetBucketQuotaRequest(bucketName, bucketQuota));
    }

    @Override
    public HeaderResponse setBucketQuota(final SetBucketQuotaRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketQuotaRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketQuota(), "The bucket '" + request.getBucketName() + "' does not include Quota information");
        return this.doActionWithResult("setBucketQuota", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.setBucketQuotaImpl(request);
            }
        });
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(String bucketName) throws ObsException {
        return this.getBucketStoragePolicy(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketStoragePolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketStoragePolicyConfiguration>(){

            @Override
            public BucketStoragePolicyConfiguration action() throws ServiceException {
                return AbstractBucketClient.this.getBucketStoragePolicyImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(String bucketName, BucketStoragePolicyConfiguration bucketStorage) throws ObsException {
        return this.setBucketStoragePolicy(new SetBucketStoragePolicyRequest(bucketName, bucketStorage));
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(final SetBucketStoragePolicyRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketStoragePolicyRequest is null");
        ServiceUtils.asserParameterNotNull(request.getBucketStorage(), "The bucket '" + request.getBucketName() + "' does not include storagePolicy information");
        return this.doActionWithResult("setBucketStoragePolicy", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.setBucketStorageImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketCors(String bucketName, BucketCors bucketCors) throws ObsException {
        return this.setBucketCors(new SetBucketCorsRequest(bucketName, bucketCors));
    }

    @Override
    public HeaderResponse setBucketCors(final SetBucketCorsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketCorsRequest is null");
        return this.doActionWithResult("setBucketCors", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.setBucketCorsImpl(request);
            }
        });
    }

    @Override
    public BucketCors getBucketCors(String bucketName) throws ObsException {
        return this.getBucketCors(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketCors getBucketCors(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketCors", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketCors>(){

            @Override
            public BucketCors action() throws ServiceException {
                return AbstractBucketClient.this.getBucketCorsImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketCors(String bucketName) throws ObsException {
        return this.deleteBucketCors(new BaseBucketRequest(bucketName));
    }

    @Override
    public HeaderResponse deleteBucketCors(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("deleteBucketCors", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.deleteBucketCorsImpl(request);
            }
        });
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(String bucketName) throws ObsException {
        return this.getBucketLogging(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        return this.doActionWithResult("getBucketLoggingConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketLoggingConfiguration>(){

            @Override
            public BucketLoggingConfiguration action() throws ServiceException {
                return AbstractBucketClient.this.getBucketLoggingConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration, boolean updateTargetACLifRequired) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration, updateTargetACLifRequired));
    }

    @Override
    public HeaderResponse setBucketLogging(String bucketName, BucketLoggingConfiguration loggingConfiguration) throws ObsException {
        return this.setBucketLogging(new SetBucketLoggingRequest(bucketName, loggingConfiguration));
    }

    @Override
    public HeaderResponse setBucketLogging(final SetBucketLoggingRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketLoggingRequest is null");
        return this.doActionWithResult("setBucketLoggingConfiguration", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.setBucketLoggingConfigurationImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketVersioning(String bucketName, BucketVersioningConfiguration versioningConfiguration) throws ObsException {
        return this.setBucketVersioning(new SetBucketVersioningRequest(bucketName, versioningConfiguration.getVersioningStatus()));
    }

    @Override
    public HeaderResponse setBucketVersioning(final SetBucketVersioningRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketVersioningRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("setBucketVersioning", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.setBucketVersioningImpl(request);
            }
        });
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(String bucketName) throws ObsException {
        return this.getBucketVersioning(new BaseBucketRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketVersioning", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketVersioningConfiguration>(){

            @Override
            public BucketVersioningConfiguration action() throws ServiceException {
                return AbstractBucketClient.this.getBucketVersioningImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketRequestPayment(String bucketName, RequestPaymentEnum payer) throws ObsException {
        return this.setBucketRequestPayment(new SetBucketRequestPaymentRequest(bucketName, payer));
    }

    @Override
    public HeaderResponse setBucketRequestPayment(final SetBucketRequestPaymentRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketRequestPaymentRequest is null");
        return this.doActionWithResult("setBucketRequestPayment", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
                ServiceUtils.asserParameterNotNull((Object)request.getPayer(), "payer is null");
                return AbstractBucketClient.this.setBucketRequestPaymentImpl(request);
            }
        });
    }

    @Override
    public RequestPaymentConfiguration getBucketRequestPayment(String bucketName) throws ObsException {
        return this.getBucketRequestPayment(new BaseBucketRequest(bucketName));
    }

    @Override
    public RequestPaymentConfiguration getBucketRequestPayment(final BaseBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketRequestPayment", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<RequestPaymentConfiguration>(){

            @Override
            public RequestPaymentConfiguration action() throws ServiceException {
                return AbstractBucketClient.this.getBucketRequestPaymentImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketCustomDomain(String bucketName, String domainName) throws ObsException {
        return this.deleteBucketCustomDomain(new DeleteBucketCustomDomainRequest(bucketName, domainName));
    }

    @Override
    public HeaderResponse deleteBucketCustomDomain(final DeleteBucketCustomDomainRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "request is null");
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getDomainName(), "domainName is null");
        return this.doActionWithResult("setBucketCustomDomain", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.deleteBucketCustomDomainImpl(request);
            }
        });
    }

    @Override
    public BucketCustomDomainInfo getBucketCustomDomain(String bucketName) throws ObsException {
        return this.getBucketCustomDomain(new GetBucketCustomDomainRequest(bucketName));
    }

    @Override
    public BucketCustomDomainInfo getBucketCustomDomain(final GetBucketCustomDomainRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BaseBucketRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getBucketName(), "bucketName is null");
        return this.doActionWithResult("getBucketCustomDomain", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<BucketCustomDomainInfo>(){

            @Override
            public BucketCustomDomainInfo action() throws ServiceException {
                return AbstractBucketClient.this.getBucketCustomDomainImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketCustomDomain(String bucketName, String domainName) throws ObsException {
        return this.setBucketCustomDomain(new SetBucketCustomDomainRequest(bucketName, domainName));
    }

    @Override
    public HeaderResponse setBucketCustomDomain(final SetBucketCustomDomainRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "request is null");
        ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getDomainName(), "domainName is null");
        return this.doActionWithResult("setBucketCustomDomain", request.getBucketName(), new AbstractClient.ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return AbstractBucketClient.this.setBucketCustomDomainImpl(request);
            }
        });
    }
}

