/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watsonx.ai;

import com.ibm.watsonx.ai.CloudRegion;
import com.ibm.watsonx.ai.core.auth.AuthenticationProvider;
import com.ibm.watsonx.ai.core.http.AsyncHttpClient;
import com.ibm.watsonx.ai.core.http.AsyncHttpInterceptor;
import com.ibm.watsonx.ai.core.http.SyncHttpClient;
import com.ibm.watsonx.ai.core.http.SyncHttpInterceptor;
import com.ibm.watsonx.ai.core.http.interceptors.BearerInterceptor;
import com.ibm.watsonx.ai.core.http.interceptors.LoggerInterceptor;
import com.ibm.watsonx.ai.core.http.interceptors.RetryInterceptor;
import com.ibm.watsonx.ai.core.provider.ExecutorProvider;
import com.ibm.watsonx.ai.core.provider.HttpClientProvider;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;

public abstract class WatsonxService {
    protected static final String ML_API_PATH = "/ml/v1";
    protected static final String ML_API_TEXT_PATH = "/ml/v1".concat("/text");
    protected static final String API_VERSION = "2025-04-23";
    protected static final String TRANSACTION_ID_HEADER = "X-Global-Transaction-Id";
    protected final URI url;
    protected final String version;
    protected final Duration timeout;
    protected final boolean logRequests;
    protected final boolean logResponses;
    protected final SyncHttpClient syncHttpClient;
    protected final AsyncHttpClient asyncHttpClient;
    protected final Executor computationExecutor;

    protected WatsonxService(Builder<?> builder) {
        this.url = Objects.requireNonNull(builder.url, "The url must be provided");
        this.version = Objects.requireNonNullElse(builder.version, API_VERSION);
        this.timeout = Objects.requireNonNullElse(builder.timeout, Duration.ofSeconds(10L));
        this.logRequests = Objects.requireNonNullElse(builder.logRequests, false);
        this.logResponses = Objects.requireNonNullElse(builder.logResponses, false);
        HttpClient httpClient = HttpClientProvider.httpClient();
        SyncHttpClient.Builder syncHttpClientBuilder = SyncHttpClient.builder().httpClient(httpClient);
        AsyncHttpClient.Builder asyncHttpClientBuilder = AsyncHttpClient.builder().httpClient(httpClient);
        syncHttpClientBuilder.interceptor((SyncHttpInterceptor)RetryInterceptor.ON_TOKEN_EXPIRED);
        asyncHttpClientBuilder.interceptor((AsyncHttpInterceptor)RetryInterceptor.ON_TOKEN_EXPIRED);
        if (Objects.nonNull(builder.authenticationProvider)) {
            BearerInterceptor bearerInterceptor = new BearerInterceptor(builder.authenticationProvider);
            syncHttpClientBuilder.interceptor((SyncHttpInterceptor)bearerInterceptor);
            asyncHttpClientBuilder.interceptor((AsyncHttpInterceptor)bearerInterceptor);
        }
        syncHttpClientBuilder.interceptor((SyncHttpInterceptor)RetryInterceptor.ON_RETRYABLE_STATUS_CODES);
        asyncHttpClientBuilder.interceptor((AsyncHttpInterceptor)RetryInterceptor.ON_RETRYABLE_STATUS_CODES);
        if (this.logRequests || this.logResponses) {
            syncHttpClientBuilder.interceptor((SyncHttpInterceptor)new LoggerInterceptor(this.logRequests, this.logResponses));
            asyncHttpClientBuilder.interceptor((AsyncHttpInterceptor)new LoggerInterceptor(this.logRequests, this.logResponses));
        }
        this.syncHttpClient = syncHttpClientBuilder.build();
        this.asyncHttpClient = asyncHttpClientBuilder.build();
        this.computationExecutor = ExecutorProvider.cpuExecutor();
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private URI url;
        private String version;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private AuthenticationProvider authenticationProvider;

        protected Builder() {
        }

        public T url(URI url) {
            this.url = url;
            return (T)this;
        }

        public T url(String url) {
            return this.url(URI.create(url));
        }

        public T url(CloudRegion url) {
            return this.url(URI.create(url.getMlEndpoint()));
        }

        public T version(String version) {
            this.version = version;
            return (T)this;
        }

        public T logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return (T)this;
        }

        public T logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return (T)this;
        }

        public T timeout(Duration timeout) {
            this.timeout = timeout;
            return (T)this;
        }

        public T authenticationProvider(AuthenticationProvider authenticationProvider) {
            this.authenticationProvider = authenticationProvider;
            return (T)this;
        }

        public AuthenticationProvider getAuthenticationProvider() {
            return this.authenticationProvider;
        }
    }

    public static abstract class ModelService
    extends ProjectService {
        protected final String modelId;

        protected ModelService(Builder<?> builder) {
            super((ProjectService.Builder<?>)builder);
            this.modelId = Objects.requireNonNull(builder.modelId, "The modelId must be provided");
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends ProjectService.Builder<T> {
            private String modelId;

            protected Builder() {
            }

            public T modelId(String modelId) {
                this.modelId = modelId;
                return (T)this;
            }
        }
    }

    public static abstract class ProjectService
    extends WatsonxService {
        protected final String projectId;
        protected final String spaceId;

        protected ProjectService(Builder<?> builder) {
            super(builder);
            this.projectId = builder.projectId;
            this.spaceId = builder.spaceId;
            if (Objects.isNull(this.projectId) && Objects.isNull(this.spaceId)) {
                throw new NullPointerException("Either projectId or spaceId must be provided");
            }
        }

        protected static abstract class Builder<T extends Builder<T>>
        extends com.ibm.watsonx.ai.WatsonxService$Builder<T> {
            private String projectId;
            private String spaceId;

            protected Builder() {
            }

            public T projectId(String projectId) {
                this.projectId = projectId;
                return (T)this;
            }

            public T spaceId(String spaceId) {
                this.spaceId = spaceId;
                return (T)this;
            }
        }
    }
}

