/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;

public class TouchEventDispatcher {
    private int previousX;
    private int previousY;

    public boolean dispatchTouchEvent(Activity activity, MotionEvent motionEvent) {
        if (!Instabug.getInstance().isTrackingUserSteps()) {
            return false;
        }
        int n2 = (int)motionEvent.getRawX();
        int n3 = (int)motionEvent.getRawY();
        if (motionEvent.getAction() == 0) {
            this.previousX = n2;
            this.previousY = n3;
        } else if (motionEvent.getAction() == 1 && this.previousX == n2 && this.previousY == n3) {
            long l2 = System.currentTimeMillis();
            activity = this.findTargetView(activity.getWindow().getDecorView(), n2, n3);
            long l3 = System.currentTimeMillis();
            InstabugSDKLogger.d("EventProcessor: Found target view in " + (l3 - l2) + " ms");
            Instabug.getInstance().viewTapped((View)activity);
            return true;
        }
        return false;
    }

    private View findTargetView(View view, int n2, int n3) {
        View view2 = null;
        int[] nArray = new int[2];
        view.getLocationInWindow(nArray);
        if (n3 >= nArray[1] && n2 >= nArray[0] && n3 <= nArray[1] + view.getHeight() && n2 <= nArray[0] + view.getWidth()) {
            if (view instanceof ViewGroup) {
                for (int i2 = 0; i2 < ((ViewGroup)view).getChildCount(); ++i2) {
                    View view3 = ((ViewGroup)view).getChildAt(i2);
                    if (view3 instanceof ViewGroup) {
                        if ((view3 = this.findTargetView((View)((ViewGroup)view3), n2, n3)) != null) {
                            view2 = view3;
                        }
                    } else if ((view3 = this.findTargetView(view3, n2, n3)) != null) {
                        view2 = view3;
                    }
                    if (view2 != null) break;
                }
                if (view2 == null) {
                    view2 = view;
                }
            } else {
                view2 = view;
            }
        } else {
            return null;
        }
        return view2;
    }
}

