/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.v4.view.GestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.instabug.library.Instabug;
import com.instabug.library.interaction.InstabugSwipeDelegate;
import com.instabug.library.util.TouchEventDispatcher;

public class InstabugActivityDelegate
implements InstabugSwipeDelegate.InstabugTouchEventForwarder {
    private final Activity mActivity;
    private GestureDetectorCompat mDetector;
    private TouchEventDispatcher dispatcher = new TouchEventDispatcher();
    private InstabugSwipeDelegate mSwipeDelegate;

    public InstabugActivityDelegate(Activity activity) {
        this.mActivity = activity;
    }

    public void onResume() {
        if (Instabug.getInstance().iG().a() == Instabug.IBGInvocationEvent.IBGInvocationEventTwoFingersSwipeLeft) {
            this.mSwipeDelegate = new InstabugSwipeDelegate(this, InstabugSwipeDelegate.GestureConfig.TwoSwipeLeft);
            this.mDetector = new GestureDetectorCompat((Context)this.mActivity, (GestureDetector.OnGestureListener)new InstabugSwipeDelegate.GestureListener(this.mSwipeDelegate));
        } else {
            this.mSwipeDelegate = null;
            this.mDetector = null;
        }
        if (Build.VERSION.SDK_INT < 14) {
            Instabug.getInstance().onResume(this.mActivity);
        }
    }

    public void onPause() {
        this.mSwipeDelegate = null;
        this.mDetector = null;
        if (Build.VERSION.SDK_INT < 14) {
            Instabug.getInstance().onPause(this.mActivity);
        }
    }

    public void onDestroy() {
        Instabug.getInstance().onDestroy(this.mActivity);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.mSwipeDelegate != null) {
            this.mSwipeDelegate.onTouchEvent(motionEvent);
        }
        return this.dispatcher.dispatchTouchEvent(this.mActivity, motionEvent);
    }

    @Override
    public void onInstabugGestureEvent(MotionEvent motionEvent) {
        this.mDetector.onTouchEvent(motionEvent);
    }
}

