/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.AsyncTask;
import android.util.Base64;
import android.view.KeyEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library._InstabugFeedbackActivity;
import com.instabug.library.c;
import com.instabug.library.d;
import com.instabug.library.dialog.d;
import com.instabug.library.internal.theming.SdkStyle;
import com.instabug.library.model.b;
import com.instabug.library.view.AnnotationView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

public class InstabugAnnotationScreen
implements View.OnClickListener,
TextView.OnEditorActionListener,
com.instabug.library.view.a {
    private final _InstabugFeedbackActivity mParentActivity;
    private com.instabug.library.presenter.a mPresenter;
    private AnnotationView mAnnotationView;
    private LinearLayout mColorPickerLayout;
    private FrameLayout mComposerLayout;
    private FrameLayout mAnnotationViewContainer;
    private View mBrushStroke;
    private View mEmailSeparator;
    private ProgressBar mProgressIndicator;
    private EditText mUserEmail;
    private EditText mUserText;
    boolean keyboardOpened = false;
    private ProgressDialog mProgressDialog;
    private TextView mPoweredByInstabugTextView;
    private ImageView mLogoImageView;

    public InstabugAnnotationScreen(_InstabugFeedbackActivity _InstabugFeedbackActivity2) {
        this.mParentActivity = _InstabugFeedbackActivity2;
    }

    @Override
    public void setScreenTitle(String string2) {
        this.mParentActivity.setTitle(string2);
    }

    public void onCreate() {
        Instabug.a.b(this.mParentActivity.getActivity());
        this.mParentActivity.getActivity().setContentView(R.layout.instabug_activity_annotation);
        this.initializeViews();
        Object object = Instabug.getInstance().iG();
        Object object2 = new com.instabug.library.interactor.c(Instabug.access$000(((Instabug.a)object).Instabug.this).b());
        Object object3 = new com.instabug.library.internal.device.a((Context)this.mParentActivity.getActivity().getApplication());
        object = Instabug.getInstance().iG();
        object3 = b.a(Instabug.getInstance().getSettingsBundle(), Instabug.access$000(((Instabug.a)object).Instabug.this).s(), (com.instabug.library.internal.device.a)object3);
        object = new com.instabug.library.internal.storage.a(this.mParentActivity.getActivity().getApplicationContext());
        this.mPresenter = new com.instabug.library.presenter.a(this, (com.instabug.library.interactor.c)object2, Instabug.getInstance().getSettingsBundle(), (b)object3, (com.instabug.library.internal.storage.a)object);
        if (this.getIntent().getBooleanExtra("com.instabug.load_own_theme", true)) {
            object2 = this.buildSdkStyle();
        } else {
            object = Instabug.getInstance().iG();
            Instabug.access$000(((Instabug.a)object).Instabug.this);
            object2 = d.a();
            if (object2 == null) {
                object2 = new SdkStyle();
                new SdkStyle().appBackgroundDrawable = new ColorDrawable(-3355444);
                ((SdkStyle)object2).headerForegroundColor = -1;
                ((SdkStyle)object2).toolbarForegroundColor = -1;
                ((SdkStyle)object2).headerBackgroundDrawable = new ColorDrawable(-16733521);
                ((SdkStyle)object2).toolbarBackgroundDrawable = new ColorDrawable(-16733521);
            }
        }
        this.mParentActivity.onViewCreated();
        this.applyStyle((SdkStyle)object2);
        if (Instabug.getInstance().getSettingsBundle().o()) {
            Instabug.getInstance().getSettingsBundle().p();
            Instabug.getInstance().showAnimatedTutorial(this.mParentActivity.getActivity());
        }
        object2 = new File(this.mParentActivity.getActivity().getExternalCacheDir() != null ? this.mParentActivity.getActivity().getExternalCacheDir() : this.mParentActivity.getActivity().getCacheDir(), "com.instabug.library.settings");
        new a(0).execute(new Object[]{object2, this});
    }

    private void applyStyle(SdkStyle object) {
        this.mParentActivity.setStyle((SdkStyle)object);
        this.mColorPickerLayout.setBackgroundDrawable(((SdkStyle)object).toolbarBackgroundDrawable);
        object = Instabug.getInstance().getFeedbackPopupColors();
        String string2 = "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";
        this.mLogoImageView = (ImageView)this.findViewById(R.id.instabug_logo);
        if (object != null) {
            this.findViewById(R.id.instabug_composer_internal_layout).setBackgroundColor(((d.a)object).a);
            this.mEmailSeparator.setBackgroundColor(((d.a)object).c);
            this.mUserText.setTextColor(((d.a)object).b);
            this.mUserText.setHintTextColor(((d.a)object).c);
            this.mUserEmail.setHintTextColor(((d.a)object).c);
            this.mUserEmail.setTextColor(((d.a)object).b);
            if (this.isColorDark(((d.a)object).a)) {
                string2 = "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";
            }
        }
        byte[] byArray = Base64.decode((byte[])string2.getBytes(), (int)0);
        object = byArray;
        object = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)((Object)object).length);
        this.mLogoImageView.setImageBitmap((Bitmap)object);
        this.mPoweredByInstabugTextView = (TextView)this.findViewById(R.id.instabug_pbi_text);
        object = this.mPoweredByInstabugTextView.getText().toString();
        if (((String)object).contains("&name&")) {
            if (((String)(object = ((String)object).replace("&name&", "Instabug"))).contains("&") || ((String)object).contains(",") || ((String)object).contains("  ") || ((String)object).contains("_") || ((String)object).contains("-")) {
                object = "Feedback Powered by Instabug";
            }
        } else {
            object = "Feedback Powered by Instabug";
        }
        this.mPoweredByInstabugTextView.setText((CharSequence)object);
    }

    public void onDestroy() {
        this.mPresenter.b();
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        try {
            this.mAnnotationView.getDrawable().setCallback(null);
            this.mAnnotationView.setDrawingCacheEnabled(false);
            this.mProgressIndicator.getProgressDrawable().setCallback(null);
            this.mProgressIndicator.getIndeterminateDrawable().setCallback(null);
            this.mEmailSeparator.getBackground().setCallback(null);
            this.mBrushStroke.getBackground().setCallback(null);
            this.mAnnotationViewContainer.getBackground().setCallback(null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isColorDark(int n2) {
        double d2;
        double d3 = 1.0 - (0.299 * (double)Color.red((int)n2) + 0.587 * (double)Color.green((int)n2) + 0.114 * (double)Color.blue((int)n2)) / 255.0;
        return !(d2 < 0.5);
    }

    private void initializeViews() {
        this.mAnnotationView = (AnnotationView)this.findViewById(R.id.annotation_view);
        this.mColorPickerLayout = (LinearLayout)this.findViewById(R.id.instabug_lyt_color_picker);
        this.mComposerLayout = (FrameLayout)this.findViewById(R.id.instabug_composer_layout);
        this.mProgressIndicator = (ProgressBar)this.findViewById(R.id.progress_spinner);
        this.mUserEmail = (EditText)this.findViewById(R.id.user_email);
        this.mEmailSeparator = this.findViewById(R.id.email_separator);
        this.mUserText = (EditText)this.findViewById(R.id.text_composer);
        this.mUserText.setHint((CharSequence)Instabug.getInstance().getCommentHint());
        this.mAnnotationViewContainer = (FrameLayout)this.findViewById(R.id.annotation_view_holder);
        this.mUserEmail.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mUserText.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mComposerLayout.setOnClickListener((View.OnClickListener)new com.instabug.library.b(this));
        this.findViewById(R.id.color_blue_button).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.color_red_button).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.color_green_button).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.color_gray_button).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.color_yellow_button).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.color_orange_button).setOnClickListener((View.OnClickListener)this);
    }

    public void clearAnnotations() {
        this.mAnnotationView.a();
    }

    private View findViewById(int n2) {
        return this.mParentActivity.getActivity().findViewById(n2);
    }

    public void onClick(View view) {
        int n2 = view.getId();
        this.dismissColorPicker();
        int n3 = R.color.instabug_annotation_color_blue;
        if (n2 == R.id.color_blue_button) {
            n3 = R.color.instabug_annotation_color_blue;
        } else if (n2 == R.id.color_red_button) {
            n3 = R.color.instabug_annotation_color_red;
        } else if (n2 == R.id.color_green_button) {
            n3 = R.color.instabug_annotation_color_green;
        } else if (n2 == R.id.color_gray_button) {
            n3 = R.color.instabug_annotation_color_gray;
        } else if (n2 == R.id.color_yellow_button) {
            n3 = R.color.instabug_annotation_color_yellow;
        } else if (n2 == R.id.color_orange_button) {
            n3 = R.color.instabug_annotation_color_orange;
        }
        this.mPresenter.a(n3);
    }

    public void onSendClicked() {
        this.mPresenter.c();
    }

    public void onCancelClicked() {
        this.mPresenter.d();
    }

    private void dismissComposer() {
        if (this.mComposerLayout.getVisibility() == 0) {
            TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
            translateAnimation.setDuration(350L);
            this.mComposerLayout.startAnimation((Animation)translateAnimation);
            this.mComposerLayout.setVisibility(8);
            this.mComposerLayout.clearFocus();
            translateAnimation = (InputMethodManager)this.getSystemService("input_method");
            if (this.mParentActivity != null && this.mParentActivity.getActivity().getCurrentFocus() != null) {
                translateAnimation.hideSoftInputFromWindow(this.mParentActivity.getActivity().getCurrentFocus().getWindowToken(), 0);
            }
        }
    }

    public void openComposer() {
        if (this.mComposerLayout.getVisibility() == 8) {
            TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
            translateAnimation.setDuration(350L);
            translateAnimation.setFillAfter(true);
            this.mComposerLayout.setVisibility(0);
            this.mComposerLayout.startAnimation((Animation)translateAnimation);
            if (Instabug.getInstance().isEmailEnabled()) {
                if (Instabug.getInstance().getDefaultEmail() == null || !Instabug.getInstance().getDefaultEmail().trim().equals(this.mUserEmail.getText().toString().trim())) {
                    this.focusOnEmail();
                    return;
                }
                this.focusOnText();
                return;
            }
            this.focusOnText();
        }
    }

    private void focusOnText() {
        this.mUserText.requestFocus();
        this.mUserText.performClick();
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mUserText, 1);
    }

    private void focusOnEmail() {
        this.mUserEmail.requestFocus();
        this.mUserEmail.performClick();
        InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mUserEmail, 1);
    }

    private Object getSystemService(String string2) {
        return this.mParentActivity.getActivity().getSystemService(string2);
    }

    private void dismissColorPicker() {
        if (this.mColorPickerLayout.getVisibility() == 0) {
            TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
            translateAnimation.setDuration(350L);
            this.mColorPickerLayout.startAnimation((Animation)translateAnimation);
            this.mColorPickerLayout.setVisibility(8);
        }
    }

    private void openColorPicker() {
        if (this.mColorPickerLayout.getVisibility() == 8) {
            TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
            translateAnimation.setDuration(350L);
            translateAnimation.setFillAfter(true);
            this.mColorPickerLayout.setVisibility(0);
            this.mColorPickerLayout.startAnimation((Animation)translateAnimation);
        }
    }

    private void sendBugReport() {
        this.mPresenter.c();
    }

    public void toggleColorPicker() {
        if (this.mColorPickerLayout.getVisibility() == 8) {
            this.openColorPicker();
            return;
        }
        this.dismissColorPicker();
    }

    @Override
    public void setCurrentColor(int n2) {
        this.mParentActivity.onBrushColorChanged(n2);
        this.mAnnotationView.a(n2);
    }

    @Override
    public String getScreenshotPath() {
        return this.getIntent().getExtras().getString("com.instabug.snapshot_file_path");
    }

    private Intent getIntent() {
        return this.mParentActivity.getActivity().getIntent();
    }

    @Override
    public void setScreenshot(Bitmap bitmap) {
        this.mAnnotationView.setImageBitmap(bitmap);
        this.mAnnotationView.setVisibility(0);
        this.mProgressIndicator.setVisibility(8);
        this.mAnnotationView.post(new c(this));
    }

    @Override
    public Bitmap getAnnotatedScreenshot() {
        this.mAnnotationView.setDrawingCacheEnabled(true);
        return this.mAnnotationView.getDrawingCache();
    }

    @Override
    public void setEmailEnabled(boolean bl) {
        if (bl) {
            this.mUserEmail.setVisibility(0);
            this.mEmailSeparator.setVisibility(0);
            return;
        }
        this.mUserEmail.setVisibility(8);
        this.mEmailSeparator.setVisibility(4);
    }

    @Override
    public void setEmail(String string2) {
        this.mUserEmail.setText((CharSequence)string2);
    }

    @Override
    public String getEmail() {
        return this.mUserEmail.getText().toString();
    }

    @Override
    public void setEmailHint(String string2) {
        this.mUserEmail.setHint((CharSequence)string2);
    }

    public String getEmailHint() {
        return this.mUserEmail.getHint().toString();
    }

    @Override
    public void setUserTextHint(String string2) {
        this.mUserText.setHint((CharSequence)string2);
    }

    @Override
    public String getUserText() {
        return this.mUserText.getText().toString();
    }

    @Override
    public void focusOnEmailField(String string2) {
        this.openComposer();
        string2 = Toast.makeText((Context)this.mParentActivity.getActivity(), (CharSequence)string2, (int)1);
        string2.setGravity(17, 0, 0);
        string2.show();
        this.mUserEmail.requestFocus();
    }

    @Override
    public void focusOnUserTextField(String string2) {
        this.openComposer();
        string2 = Toast.makeText((Context)this.mParentActivity.getActivity(), (CharSequence)string2, (int)1);
        string2.setGravity(17, 0, 0);
        string2.show();
        this.mUserText.requestFocus();
    }

    @Override
    public void displayProgressDialog(String string2) {
        this.mProgressDialog = ProgressDialog.show((Context)this.mParentActivity.getActivity(), null, (CharSequence)string2, (boolean)false, (boolean)false);
    }

    @Override
    public void dismissAnnotationView() {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        this.mParentActivity.getActivity().finish();
    }

    @Override
    public void dismissAnnotationView(String string2) {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
        string2 = Toast.makeText((Context)this.mParentActivity.getActivity(), (CharSequence)string2, (int)1);
        string2.setGravity(17, 0, 0);
        string2.show();
        this.mParentActivity.getActivity().finish();
    }

    public boolean onEditorAction(TextView object, int n2, KeyEvent keyEvent) {
        try {
            if (keyEvent != null && keyEvent.getKeyCode() == 4) {
                this.keyboardOpened = false;
            }
            if (n2 == 6) {
                this.sendBugReport();
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return false;
    }

    public void onResume() {
        this.mPresenter.a();
    }

    public void onBackPressed() {
        if (this.mComposerLayout.getVisibility() == 0) {
            this.dismissComposer();
            return;
        }
        this.mPresenter.d();
    }

    private SdkStyle buildSdkStyle() {
        return new com.instabug.library.internal.theming.a().a(this.mParentActivity.getActivity());
    }

    private void loadSettings(JSONObject jSONObject) {
        if (jSONObject != null && jSONObject.optBoolean("white_label", false)) {
            this.mPoweredByInstabugTextView.setVisibility(4);
            this.mLogoImageView.setVisibility(4);
        }
    }

    public int getTopBarContainerId() {
        return R.id.instabug_titlebar;
    }

    public int getTopBarLayoutId() {
        return R.layout.instabug_lyt_top_bar;
    }

    public int getTopBarId() {
        return R.id.instabug_top_bar_toolbar;
    }

    public int getBottomBarContainerId() {
        return R.id.instabug_toolbar;
    }

    public int getBottomBarId() {
        return R.id.instabug_bottom_bar_toolbar;
    }

    public int getBottomBarLayoutId() {
        return R.layout.instabug_lyt_bottom_bar;
    }

    public int getBackIconId() {
        return R.drawable.instabug_ic_back;
    }

    public int getTopMenuId() {
        return R.menu.instabug_annotation_top_menu;
    }

    public int getBottomMenuId() {
        return R.menu.instabug_annotation_bottom_menu;
    }

    public int getBackActionId() {
        return R.id.instabug_action_cancel;
    }

    public int getSendActionId() {
        return R.id.instabug_action_send;
    }

    public int getPickColorActionId() {
        return R.id.instabug_action_pick_color;
    }

    public int getOpenComposerActionId() {
        return R.id.instabug_action_open_composer;
    }

    public int getClearAnnotationsActionId() {
        return R.id.instabug_action_clear_annotations;
    }

    public int getBrushStrokeId() {
        return R.id.instabug_brush_stroke;
    }

    static /* synthetic */ void access$100(InstabugAnnotationScreen instabugAnnotationScreen) {
        instabugAnnotationScreen.dismissComposer();
    }

    static /* synthetic */ FrameLayout access$200(InstabugAnnotationScreen instabugAnnotationScreen) {
        return instabugAnnotationScreen.mAnnotationViewContainer;
    }

    static /* synthetic */ AnnotationView access$300(InstabugAnnotationScreen instabugAnnotationScreen) {
        return instabugAnnotationScreen.mAnnotationView;
    }

    static final class a
    extends AsyncTask<Object, Void, JSONObject> {
        private WeakReference<InstabugAnnotationScreen> a;

        private a() {
        }

        private JSONObject a(Object ... object) {
            try {
                this.a = new WeakReference<InstabugAnnotationScreen>((InstabugAnnotationScreen)object[1]);
                object = new BufferedReader(new FileReader((File)object[0]));
                String string2 = ((BufferedReader)object).readLine();
                ((BufferedReader)object).close();
                return new JSONObject(string2);
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected final /* synthetic */ void onPostExecute(Object object) {
            JSONObject jSONObject = (JSONObject)object;
            object = this;
            if (((a)((Object)object)).a.get() != null) {
                ((InstabugAnnotationScreen)((a)((Object)object)).a.get()).loadSettings(jSONObject);
            }
            super.onPostExecute((Object)jSONObject);
        }

        protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.a(objectArray);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

