/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.TextView;
import com.instabug.library.InstabugAnnotationScreen;
import com.instabug.library._InstabugFeedbackActivity;
import com.instabug.library.internal.theming.SdkStyle;

public class InstabugFeedbackActivity
extends Activity
implements _InstabugFeedbackActivity,
View.OnClickListener {
    private InstabugAnnotationScreen annotationScreen;
    private SdkStyle mSdkStyle;
    private TextView mTitleTextView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.annotationScreen = new InstabugAnnotationScreen((_InstabugFeedbackActivity)this);
        this.annotationScreen.onCreate();
        this.getLayoutInflater().inflate(this.annotationScreen.getTopBarLayoutId(), (ViewGroup)this.findViewById(this.annotationScreen.getTopBarContainerId()));
        this.getLayoutInflater().inflate(this.annotationScreen.getBottomBarLayoutId(), (ViewGroup)this.findViewById(this.annotationScreen.getBottomBarContainerId()));
        this.setTopBarBackground(this.mSdkStyle.headerBackgroundDrawable);
        this.setToolBarBackground(this.mSdkStyle.toolbarBackgroundDrawable);
        if (this.findTitleView() != null) {
            if (this.mSdkStyle.headerTextAppearanceResId != 0) {
                this.mTitleTextView.setTextAppearance((Context)this, this.mSdkStyle.headerTextAppearanceResId);
            } else {
                this.mTitleTextView.setTextColor(this.mSdkStyle.headerForegroundColor);
            }
        }
        ((ImageButton)this.findViewById(this.annotationScreen.getSendActionId())).setColorFilter(this.mSdkStyle.headerForegroundColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(this.annotationScreen.getOpenComposerActionId())).setColorFilter(this.mSdkStyle.headerForegroundColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(this.annotationScreen.getPickColorActionId())).setColorFilter(this.mSdkStyle.headerForegroundColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(this.annotationScreen.getClearAnnotationsActionId())).setColorFilter(this.mSdkStyle.headerForegroundColor, PorterDuff.Mode.SRC_ATOP);
        ((ImageButton)this.findViewById(this.annotationScreen.getBackActionId())).setColorFilter(this.mSdkStyle.headerForegroundColor, PorterDuff.Mode.SRC_ATOP);
    }

    protected void onResume() {
        super.onResume();
        this.annotationScreen.onResume();
    }

    public void onBackPressed() {
        this.annotationScreen.onBackPressed();
        super.onBackPressed();
    }

    protected void onDestroy() {
        this.annotationScreen.onDestroy();
        super.onDestroy();
    }

    public Activity getActivity() {
        return this;
    }

    TextView findTitleView() {
        if (this.mTitleTextView != null) {
            return this.mTitleTextView;
        }
        ViewGroup titleBarViewGroup = (ViewGroup)this.findViewById(this.annotationScreen.getTopBarId());
        for (int i = 0; i < titleBarViewGroup.getChildCount(); ++i) {
            View childView = titleBarViewGroup.getChildAt(i);
            if (!(childView instanceof TextView)) continue;
            this.mTitleTextView = (TextView)childView;
            return this.mTitleTextView;
        }
        return null;
    }

    public void setTitle(String title) {
        if (this.findTitleView() != null) {
            this.findTitleView().setText((CharSequence)title);
        }
    }

    public void setTopBarBackground(Drawable headerBackgroundDrawable) {
        this.findViewById(this.annotationScreen.getTopBarId()).setBackgroundDrawable(headerBackgroundDrawable);
    }

    public void setToolBarBackground(Drawable toolbarBackgroundDrawable) {
        this.findViewById(this.annotationScreen.getBottomBarContainerId()).setBackgroundDrawable(toolbarBackgroundDrawable);
    }

    public void setStyle(SdkStyle style) {
        this.mSdkStyle = style;
    }

    public void onViewCreated() {
    }

    public void onBrushColorChanged(int currentColor) {
        this.findViewById(this.annotationScreen.getBrushStrokeId()).setBackgroundColor(this.getResources().getColor(currentColor));
    }

    public void onClick(View view) {
        if (view.getId() == this.annotationScreen.getSendActionId()) {
            this.annotationScreen.onSendClicked();
            return;
        }
        if (view.getId() == this.annotationScreen.getOpenComposerActionId()) {
            this.annotationScreen.openComposer();
            return;
        }
        if (view.getId() == this.annotationScreen.getClearAnnotationsActionId()) {
            this.annotationScreen.clearAnnotations();
            return;
        }
        if (view.getId() == this.annotationScreen.getPickColorActionId()) {
            this.annotationScreen.toggleColorPicker();
            return;
        }
        this.annotationScreen.onCancelClicked();
    }
}

