/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.board.v1.model;

import com.google.gson.annotations.SerializedName;
import com.lark.oapi.service.board.v1.enums.ConnectorConnectorLineShapeEnum;
import com.lark.oapi.service.board.v1.model.ConnectorAttachedObject;
import com.lark.oapi.service.board.v1.model.ConnectorCaption;
import com.lark.oapi.service.board.v1.model.ConnectorInfo;
import com.lark.oapi.service.board.v1.model.Point;

public class Connector {
    @SerializedName(value="start_object")
    private ConnectorAttachedObject startObject;
    @SerializedName(value="end_object")
    private ConnectorAttachedObject endObject;
    @SerializedName(value="start")
    private ConnectorInfo start;
    @SerializedName(value="end")
    private ConnectorInfo end;
    @SerializedName(value="captions")
    private ConnectorCaption captions;
    @SerializedName(value="shape")
    private String shape;
    @SerializedName(value="turning_points")
    private Point[] turningPoints;

    public Connector() {
    }

    public Connector(Builder builder) {
        this.startObject = builder.startObject;
        this.endObject = builder.endObject;
        this.start = builder.start;
        this.end = builder.end;
        this.captions = builder.captions;
        this.shape = builder.shape;
        this.turningPoints = builder.turningPoints;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ConnectorAttachedObject getStartObject() {
        return this.startObject;
    }

    public void setStartObject(ConnectorAttachedObject startObject) {
        this.startObject = startObject;
    }

    public ConnectorAttachedObject getEndObject() {
        return this.endObject;
    }

    public void setEndObject(ConnectorAttachedObject endObject) {
        this.endObject = endObject;
    }

    public ConnectorInfo getStart() {
        return this.start;
    }

    public void setStart(ConnectorInfo start) {
        this.start = start;
    }

    public ConnectorInfo getEnd() {
        return this.end;
    }

    public void setEnd(ConnectorInfo end) {
        this.end = end;
    }

    public ConnectorCaption getCaptions() {
        return this.captions;
    }

    public void setCaptions(ConnectorCaption captions) {
        this.captions = captions;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public Point[] getTurningPoints() {
        return this.turningPoints;
    }

    public void setTurningPoints(Point[] turningPoints) {
        this.turningPoints = turningPoints;
    }

    public static class Builder {
        private ConnectorAttachedObject startObject;
        private ConnectorAttachedObject endObject;
        private ConnectorInfo start;
        private ConnectorInfo end;
        private ConnectorCaption captions;
        private String shape;
        private Point[] turningPoints;

        public Builder startObject(ConnectorAttachedObject startObject) {
            this.startObject = startObject;
            return this;
        }

        public Builder endObject(ConnectorAttachedObject endObject) {
            this.endObject = endObject;
            return this;
        }

        public Builder start(ConnectorInfo start) {
            this.start = start;
            return this;
        }

        public Builder end(ConnectorInfo end) {
            this.end = end;
            return this;
        }

        public Builder captions(ConnectorCaption captions) {
            this.captions = captions;
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public Builder shape(ConnectorConnectorLineShapeEnum shape) {
            this.shape = shape.getValue();
            return this;
        }

        public Builder turningPoints(Point[] turningPoints) {
            this.turningPoints = turningPoints;
            return this;
        }

        public Connector build() {
            return new Connector(this);
        }
    }
}

