/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.brave;

import brave.Span;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.internal.common.brave.SpanContextUtil;
import java.net.InetSocketAddress;

public final class SpanTags {
    private static final String WIRE_SEND_ANNOTATION = "ws";
    private static final String WIRE_RECEIVE_ANNOTATION = "wr";
    public static final String TAG_HTTP_HOST = "http.host";
    public static final String TAG_HTTP_URL = "http.url";
    public static final String TAG_HTTP_PROTOCOL = "http.protocol";
    public static final String TAG_HTTP_SERIALIZATION_FORMAT = "http.serfmt";
    public static final String TAG_ADDRESS_REMOTE = "address.remote";
    public static final String TAG_ADDRESS_LOCAL = "address.local";

    public static void logWireSend(Span span, long wireSendTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireSendTimeNanos), WIRE_SEND_ANNOTATION);
    }

    public static void logWireReceive(Span span, long wireReceiveTimeNanos, RequestLog requestLog) {
        span.annotate(SpanContextUtil.wallTimeMicros(requestLog, wireReceiveTimeNanos), WIRE_RECEIVE_ANNOTATION);
    }

    public static boolean updateRemoteEndpoint(Span span, RequestContext ctx) {
        InetSocketAddress remoteAddress = ctx.remoteAddress();
        if (remoteAddress != null) {
            return span.remoteIpAndPort(remoteAddress.getAddress().getHostAddress(), remoteAddress.getPort());
        }
        return false;
    }

    private SpanTags() {
    }
}

