/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit;

import com.netflix.concurrency.limits.Limit;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class AbstractLimit
implements Limit {
    private volatile int limit;
    private final List<Consumer<Integer>> listeners = new CopyOnWriteArrayList<Consumer<Integer>>();

    protected AbstractLimit(int initialLimit) {
        this.limit = initialLimit;
    }

    @Override
    public final synchronized void onSample(long startTime, long rtt, int inflight, boolean didDrop) {
        this.setLimit(this._update(startTime, rtt, inflight, didDrop));
    }

    protected abstract int _update(long var1, long var3, int var5, boolean var6);

    @Override
    public final int getLimit() {
        return this.limit;
    }

    protected synchronized void setLimit(int newLimit) {
        if (newLimit != this.limit) {
            this.limit = newLimit;
            this.listeners.forEach(listener -> listener.accept(newLimit));
        }
    }

    @Override
    public void notifyOnChange(Consumer<Integer> consumer) {
        this.listeners.add(consumer);
    }
}

