/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskScheduler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ShortfallEvaluator {
    private static final long TOO_OLD_THRESHOLD_MILLIS = 900000L;
    private final TaskScheduler phantomTaskScheduler;
    private final Map<String, Long> requestedForTasksSet = new HashMap<String, Long>();

    ShortfallEvaluator(TaskScheduler phantomTaskScheduler) {
        this.phantomTaskScheduler = phantomTaskScheduler;
    }

    Map<String, Integer> getShortfall(Set<String> attrKeys, Set<TaskRequest> failures) {
        HashMap<String, Integer> shortfallMap = new HashMap<String, Integer>();
        if (attrKeys != null && failures != null && !failures.isEmpty()) {
            this.removeOldInserts();
            int shortfall = 0;
            long now = System.currentTimeMillis();
            for (TaskRequest r : failures) {
                String tid = r.getId();
                if (this.requestedForTasksSet.get(tid) != null) continue;
                this.requestedForTasksSet.put(tid, now);
                ++shortfall;
            }
            for (String key : attrKeys) {
                shortfallMap.put(key, shortfall);
            }
        }
        return shortfallMap;
    }

    private void removeOldInserts() {
        long tooOld = System.currentTimeMillis() - 900000L;
        HashSet<String> tasks = new HashSet<String>(this.requestedForTasksSet.keySet());
        for (String t : tasks) {
            if (this.requestedForTasksSet.get(t) >= tooOld) continue;
            this.requestedForTasksSet.remove(t);
        }
    }
}

