/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.config.ConfigurationManager;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import rx.functions.Action1;
import rx.functions.Func1;

public abstract class HystrixConcurrencyStrategy {
    public ThreadPoolExecutor getThreadPool(final HystrixThreadPoolKey threadPoolKey, HystrixProperty<Integer> corePoolSize, HystrixProperty<Integer> maximumPoolSize, HystrixProperty<Integer> keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        return new ThreadPoolExecutor((int)corePoolSize.get(), (int)maximumPoolSize.get(), (long)keepAliveTime.get().intValue(), unit, workQueue, new ThreadFactory(){
            protected final AtomicInteger threadNumber = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "hystrix-" + threadPoolKey.name() + "-" + this.threadNumber.incrementAndGet());
            }
        });
    }

    public BlockingQueue<Runnable> getBlockingQueue(int maxQueueSize) {
        if (maxQueueSize <= 0) {
            return new SynchronousQueue<Runnable>();
        }
        return new LinkedBlockingQueue<Runnable>(maxQueueSize);
    }

    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return callable;
    }

    public <T> HystrixRequestVariable<T> getRequestVariable(final HystrixRequestVariableLifecycle<T> rv) {
        return new HystrixRequestVariableDefault<T>(){

            @Override
            public T initialValue() {
                return rv.initialValue();
            }

            @Override
            public void shutdown(T value) {
                rv.shutdown(value);
            }
        };
    }

    public static class UnitTest {
        @Before
        public void prepareForTest() {
            HystrixRequestContext.initializeContext();
        }

        @After
        public void cleanup() {
            if (HystrixRequestContext.getContextForCurrentThread() != null) {
                HystrixRequestContext.getContextForCurrentThread().shutdown();
            }
            ConfigurationManager.getConfigInstance().clear();
        }

        @Test
        public void testRequestContextPropagatesAcrossObserveOnPool() {
            new SimpleCommand().execute();
            new SimpleCommand().observe().map((Func1)new Func1<String, String>(){

                public String call(String s) {
                    System.out.println("Map => Commands: " + HystrixRequestLog.getCurrentRequest().getExecutedCommands());
                    return s;
                }
            }).toBlockingObservable().forEach((Action1)new Action1<String>(){

                public void call(String s) {
                    System.out.println("Result [" + s + "] => Commands: " + HystrixRequestLog.getCurrentRequest().getExecutedCommands());
                }
            });
        }

        private static class SimpleCommand
        extends HystrixCommand<String> {
            public SimpleCommand() {
                super(HystrixCommandGroupKey.Factory.asKey("SimpleCommand"));
            }

            @Override
            protected String run() throws Exception {
                System.out.println("Executing => Commands: " + HystrixRequestLog.getCurrentRequest().getExecutedCommands());
                return "Hello";
            }
        }
    }
}

