/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableHolder;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestVariableLifecycle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRequestLog {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRequestLog.class);
    static final int MAX_STORAGE = 1000;
    private static final HystrixRequestVariableHolder<HystrixRequestLog> currentRequestLog = new HystrixRequestVariableHolder<HystrixRequestLog>(new HystrixRequestVariableLifecycle<HystrixRequestLog>(){

        @Override
        public HystrixRequestLog initialValue() {
            return new HystrixRequestLog();
        }

        @Override
        public void shutdown(HystrixRequestLog value) {
        }
    });
    private LinkedBlockingQueue<HystrixCommand<?>> executedCommands = new LinkedBlockingQueue(1000);
    private LinkedBlockingQueue<HystrixInvokableInfo<?>> allExecutedCommands = new LinkedBlockingQueue(1000);

    private HystrixRequestLog() {
    }

    public static HystrixRequestLog getCurrentRequest(HystrixConcurrencyStrategy concurrencyStrategy) {
        return currentRequestLog.get(concurrencyStrategy);
    }

    public static HystrixRequestLog getCurrentRequest() {
        return currentRequestLog.get(HystrixPlugins.getInstance().getConcurrencyStrategy());
    }

    @Deprecated
    public Collection<HystrixCommand<?>> getExecutedCommands() {
        return Collections.unmodifiableCollection(this.executedCommands);
    }

    public Collection<HystrixInvokableInfo<?>> getAllExecutedCommands() {
        return Collections.unmodifiableCollection(this.allExecutedCommands);
    }

    void addExecutedCommand(HystrixInvokableInfo<?> command) {
        HystrixCommand _c;
        if (!this.allExecutedCommands.offer(command)) {
            logger.warn("RequestLog ignoring command after reaching limit of 1000. See https://github.com/Netflix/Hystrix/issues/53 for more information.");
        }
        if (command instanceof HystrixCommand && !this.executedCommands.offer(_c = (HystrixCommand)command)) {
            logger.warn("RequestLog ignoring command after reaching limit of 1000. See https://github.com/Netflix/Hystrix/issues/53 for more information.");
        }
    }

    public String getExecutedCommandsAsString() {
        try {
            LinkedHashMap<String, Integer> aggregatedCommandsExecuted = new LinkedHashMap<String, Integer>();
            HashMap<String, Integer> aggregatedCommandExecutionTime = new HashMap<String, Integer>();
            StringBuilder builder = new StringBuilder();
            int estimatedLength = 0;
            for (HystrixInvokableInfo<?> command : this.allExecutedCommands) {
                builder.setLength(0);
                builder.append(command.getCommandKey().name());
                ArrayList<HystrixEventType> events = new ArrayList<HystrixEventType>(command.getExecutionEvents());
                if (events.size() > 0) {
                    Collections.sort(events);
                    builder.append("[");
                    block7: for (HystrixEventType event : events) {
                        switch (event) {
                            case EMIT: {
                                int numEmissions = command.getNumberEmissions();
                                if (numEmissions > 1) {
                                    builder.append((Object)event).append("x").append(numEmissions).append(", ");
                                    continue block7;
                                }
                                builder.append((Object)event).append(", ");
                                continue block7;
                            }
                            case FALLBACK_EMIT: {
                                int numFallbackEmissions = command.getNumberFallbackEmissions();
                                if (numFallbackEmissions > 1) {
                                    builder.append((Object)event).append("x").append(numFallbackEmissions).append(", ");
                                    continue block7;
                                }
                                builder.append((Object)event).append(", ");
                                continue block7;
                            }
                        }
                        builder.append((Object)event).append(", ");
                    }
                    builder.setCharAt(builder.length() - 2, ']');
                    builder.setLength(builder.length() - 1);
                } else {
                    builder.append("[Executed]");
                }
                String display = builder.toString();
                estimatedLength += display.length() + 12;
                Integer counter = (Integer)aggregatedCommandsExecuted.get(display);
                if (counter != null) {
                    aggregatedCommandsExecuted.put(display, counter + 1);
                } else {
                    aggregatedCommandsExecuted.put(display, 1);
                }
                int executionTime = command.getExecutionTimeInMilliseconds();
                if (executionTime < 0) {
                    executionTime = 0;
                }
                if ((counter = (Integer)aggregatedCommandExecutionTime.get(display)) != null && executionTime > 0) {
                    aggregatedCommandExecutionTime.put(display, (Integer)aggregatedCommandExecutionTime.get(display) + executionTime);
                    continue;
                }
                aggregatedCommandExecutionTime.put(display, executionTime);
            }
            builder.setLength(0);
            builder.ensureCapacity(estimatedLength);
            for (String displayString : aggregatedCommandsExecuted.keySet()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(displayString);
                int totalExecutionTime = (Integer)aggregatedCommandExecutionTime.get(displayString);
                builder.append("[").append(totalExecutionTime).append("ms]");
                int count = (Integer)aggregatedCommandsExecuted.get(displayString);
                if (count <= 1) continue;
                builder.append("x").append(count);
            }
            return builder.toString();
        }
        catch (Exception e) {
            logger.error("Failed to create HystrixRequestLog response header string.", (Throwable)e);
            return "Unknown";
        }
    }
}

