/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.ExecutionResult;
import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCachedObservable;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixCommandResponseFromCache;
import com.netflix.hystrix.HystrixCounters;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.exception.HystrixTimeoutException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subjects.ReplaySubject;
import rx.subscriptions.CompositeSubscription;

abstract class AbstractCommand<R>
implements HystrixInvokableInfo<R>,
HystrixObservable<R> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCommand.class);
    protected final HystrixCircuitBreaker circuitBreaker;
    protected final HystrixThreadPool threadPool;
    protected final HystrixThreadPoolKey threadPoolKey;
    protected final HystrixCommandProperties properties;
    protected final HystrixCommandMetrics metrics;
    protected final HystrixCommandKey commandKey;
    protected final HystrixCommandGroupKey commandGroup;
    protected final HystrixEventNotifier eventNotifier;
    protected final HystrixConcurrencyStrategy concurrencyStrategy;
    protected final HystrixCommandExecutionHook executionHook;
    protected final TryableSemaphore fallbackSemaphoreOverride;
    protected static final ConcurrentHashMap<String, TryableSemaphore> fallbackSemaphorePerCircuit = new ConcurrentHashMap();
    protected final TryableSemaphore executionSemaphoreOverride;
    protected static final ConcurrentHashMap<String, TryableSemaphore> executionSemaphorePerCircuit = new ConcurrentHashMap();
    protected final AtomicReference<Reference<HystrixTimer.TimerListener>> timeoutTimer = new AtomicReference();
    protected AtomicReference<CommandState> commandState = new AtomicReference<CommandState>(CommandState.NOT_STARTED);
    protected AtomicReference<ThreadState> threadState = new AtomicReference<ThreadState>(ThreadState.NOT_USING_THREAD);
    protected volatile ExecutionResult executionResult = ExecutionResult.EMPTY;
    protected volatile boolean isResponseFromCache = false;
    protected volatile ExecutionResult executionResultAtTimeOfCancellation;
    protected volatile long commandStartTimestamp = -1L;
    protected final AtomicReference<TimedOutStatus> isCommandTimedOut = new AtomicReference<TimedOutStatus>(TimedOutStatus.NOT_EXECUTED);
    protected volatile Action0 endCurrentThreadExecutingCommand;
    protected final HystrixRequestCache requestCache;
    protected final HystrixRequestLog currentRequestLog;
    private static ConcurrentHashMap<Class<?>, String> defaultNameCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<HystrixCommandKey, Boolean> commandContainsFallback = new ConcurrentHashMap();

    static String getDefaultNameFromClass(Class<?> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    protected AbstractCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, TryableSemaphore fallbackSemaphore, TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        this.commandGroup = AbstractCommand.initGroupKey(group);
        this.commandKey = AbstractCommand.initCommandKey(key, this.getClass());
        this.properties = AbstractCommand.initCommandProperties(this.commandKey, propertiesStrategy, commandPropertiesDefaults);
        this.threadPoolKey = AbstractCommand.initThreadPoolKey(threadPoolKey, this.commandGroup, this.properties.executionIsolationThreadPoolKeyOverride().get());
        this.metrics = AbstractCommand.initMetrics(metrics, this.commandGroup, this.threadPoolKey, this.commandKey, this.properties);
        this.circuitBreaker = AbstractCommand.initCircuitBreaker(this.properties.circuitBreakerEnabled().get(), circuitBreaker, this.commandGroup, this.commandKey, this.properties, this.metrics);
        this.threadPool = AbstractCommand.initThreadPool(threadPool, this.threadPoolKey, threadPoolPropertiesDefaults);
        this.eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(this.commandKey, this.commandGroup, this.metrics, this.circuitBreaker, this.properties);
        this.executionHook = AbstractCommand.initExecutionHook(executionHook);
        this.requestCache = HystrixRequestCache.getInstance(this.commandKey, this.concurrencyStrategy);
        this.currentRequestLog = AbstractCommand.initRequestLog(this.properties.requestLogEnabled().get(), this.concurrencyStrategy);
        this.fallbackSemaphoreOverride = fallbackSemaphore;
        this.executionSemaphoreOverride = executionSemaphore;
    }

    private static HystrixCommandGroupKey initGroupKey(HystrixCommandGroupKey fromConstructor) {
        if (fromConstructor == null) {
            throw new IllegalStateException("HystrixCommandGroup can not be NULL");
        }
        return fromConstructor;
    }

    private static HystrixCommandKey initCommandKey(HystrixCommandKey fromConstructor, Class<?> clazz) {
        if (fromConstructor == null || fromConstructor.name().trim().equals("")) {
            String keyName = AbstractCommand.getDefaultNameFromClass(clazz);
            return HystrixCommandKey.Factory.asKey(keyName);
        }
        return fromConstructor;
    }

    private static HystrixCommandProperties initCommandProperties(HystrixCommandKey commandKey, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandProperties.Setter commandPropertiesDefaults) {
        if (propertiesStrategy == null) {
            return HystrixPropertiesFactory.getCommandProperties(commandKey, commandPropertiesDefaults);
        }
        return propertiesStrategy.getCommandProperties(commandKey, commandPropertiesDefaults);
    }

    private static HystrixThreadPoolKey initThreadPoolKey(HystrixThreadPoolKey threadPoolKey, HystrixCommandGroupKey groupKey, String threadPoolKeyOverride) {
        if (threadPoolKeyOverride == null) {
            if (threadPoolKey == null) {
                return HystrixThreadPoolKey.Factory.asKey(groupKey.name());
            }
            return threadPoolKey;
        }
        return HystrixThreadPoolKey.Factory.asKey(threadPoolKeyOverride);
    }

    private static HystrixCommandMetrics initMetrics(HystrixCommandMetrics fromConstructor, HystrixCommandGroupKey groupKey, HystrixThreadPoolKey threadPoolKey, HystrixCommandKey commandKey, HystrixCommandProperties properties) {
        if (fromConstructor == null) {
            return HystrixCommandMetrics.getInstance(commandKey, groupKey, threadPoolKey, properties);
        }
        return fromConstructor;
    }

    private static HystrixCircuitBreaker initCircuitBreaker(boolean enabled, HystrixCircuitBreaker fromConstructor, HystrixCommandGroupKey groupKey, HystrixCommandKey commandKey, HystrixCommandProperties properties, HystrixCommandMetrics metrics) {
        if (enabled) {
            if (fromConstructor == null) {
                return HystrixCircuitBreaker.Factory.getInstance(commandKey, groupKey, properties, metrics);
            }
            return fromConstructor;
        }
        return new HystrixCircuitBreaker.NoOpCircuitBreaker();
    }

    private static HystrixCommandExecutionHook initExecutionHook(HystrixCommandExecutionHook fromConstructor) {
        if (fromConstructor == null) {
            return new ExecutionHookDeprecationWrapper(HystrixPlugins.getInstance().getCommandExecutionHook());
        }
        if (fromConstructor instanceof ExecutionHookDeprecationWrapper) {
            return fromConstructor;
        }
        return new ExecutionHookDeprecationWrapper(fromConstructor);
    }

    private static HystrixThreadPool initThreadPool(HystrixThreadPool fromConstructor, HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults) {
        if (fromConstructor == null) {
            return HystrixThreadPool.Factory.getInstance(threadPoolKey, threadPoolPropertiesDefaults);
        }
        return fromConstructor;
    }

    private static HystrixRequestLog initRequestLog(boolean enabled, HystrixConcurrencyStrategy concurrencyStrategy) {
        if (enabled) {
            return HystrixRequestLog.getCurrentRequest(concurrencyStrategy);
        }
        return null;
    }

    void markAsCollapsedCommand(HystrixCollapserKey collapserKey, int sizeOfBatch) {
        this.eventNotifier.markEvent(HystrixEventType.COLLAPSED, this.commandKey);
        this.executionResult = this.executionResult.markCollapsed(collapserKey, sizeOfBatch);
    }

    @Override
    public Observable<R> observe() {
        ReplaySubject subject = ReplaySubject.create();
        final Subscription sourceSubscription = this.toObservable().subscribe((Observer)subject);
        return subject.doOnUnsubscribe(new Action0(){

            public void call() {
                sourceSubscription.unsubscribe();
            }
        });
    }

    protected abstract Observable<R> getExecutionObservable();

    protected abstract Observable<R> getFallbackObservable();

    @Override
    public Observable<R> toObservable() {
        Observable afterCache;
        HystrixCommandResponseFromCache fromCache;
        if (!this.commandState.compareAndSet(CommandState.NOT_STARTED, CommandState.OBSERVABLE_CHAIN_CREATED)) {
            throw new IllegalStateException("This instance can only be executed once. Please instantiate a new instance.");
        }
        this.commandStartTimestamp = System.currentTimeMillis();
        if (this.properties.requestLogEnabled().get().booleanValue() && this.currentRequestLog != null) {
            this.currentRequestLog.addExecutedCommand(this);
        }
        boolean requestCacheEnabled = this.isRequestCachingEnabled();
        String cacheKey = this.getCacheKey();
        final AbstractCommand _cmd = this;
        if (requestCacheEnabled && (fromCache = (HystrixCommandResponseFromCache)this.requestCache.get(cacheKey)) != null) {
            this.isResponseFromCache = true;
            return this.handleRequestCacheHitAndEmitValues(fromCache, _cmd);
        }
        Action0 terminateCommandCleanup = new Action0(){

            public void call() {
                if (_cmd.commandState.compareAndSet(CommandState.OBSERVABLE_CHAIN_CREATED, CommandState.TERMINAL)) {
                    AbstractCommand.this.handleCommandEnd(_cmd, false);
                } else if (_cmd.commandState.compareAndSet(CommandState.USER_CODE_EXECUTED, CommandState.TERMINAL)) {
                    AbstractCommand.this.handleCommandEnd(_cmd, true);
                }
            }
        };
        Action0 unsubscribeCommandCleanup = new Action0(){

            public void call() {
                if (_cmd.commandState.compareAndSet(CommandState.OBSERVABLE_CHAIN_CREATED, CommandState.UNSUBSCRIBED)) {
                    _cmd.eventNotifier.markEvent(HystrixEventType.CANCELLED, _cmd.commandKey);
                    _cmd.executionResultAtTimeOfCancellation = _cmd.executionResult.addEvent((int)(System.currentTimeMillis() - _cmd.commandStartTimestamp), HystrixEventType.CANCELLED);
                    AbstractCommand.this.handleCommandEnd(_cmd, false);
                } else if (_cmd.commandState.compareAndSet(CommandState.USER_CODE_EXECUTED, CommandState.UNSUBSCRIBED)) {
                    _cmd.eventNotifier.markEvent(HystrixEventType.CANCELLED, _cmd.commandKey);
                    _cmd.executionResultAtTimeOfCancellation = _cmd.executionResult.addEvent((int)(System.currentTimeMillis() - _cmd.commandStartTimestamp), HystrixEventType.CANCELLED);
                    AbstractCommand.this.handleCommandEnd(_cmd, true);
                }
            }
        };
        Func0 applyHystrixSemantics = new Func0<Observable<R>>(){

            public Observable<R> call() {
                return AbstractCommand.this.applyHystrixSemantics(_cmd);
            }
        };
        Func1 wrapWithAllOnNextHooks = new Func1<R, R>(){

            public R call(R r) {
                Object afterFirstApplication = r;
                try {
                    afterFirstApplication = AbstractCommand.this.executionHook.onComplete(_cmd, r);
                }
                catch (Throwable hookEx) {
                    logger.warn("Error calling HystrixCommandExecutionHook.onComplete", hookEx);
                }
                try {
                    return AbstractCommand.this.executionHook.onEmit(_cmd, afterFirstApplication);
                }
                catch (Throwable hookEx) {
                    logger.warn("Error calling HystrixCommandExecutionHook.onEmit", hookEx);
                    return afterFirstApplication;
                }
            }
        };
        Action0 fireOnCompletedHook = new Action0(){

            public void call() {
                try {
                    AbstractCommand.this.executionHook.onSuccess(_cmd);
                }
                catch (Throwable hookEx) {
                    logger.warn("Error calling HystrixCommandExecutionHook.onSuccess", hookEx);
                }
            }
        };
        Observable hystrixObservable = Observable.defer((Func0)applyHystrixSemantics).map(wrapWithAllOnNextHooks);
        if (requestCacheEnabled && cacheKey != null) {
            HystrixCachedObservable toCache = HystrixCachedObservable.from(hystrixObservable, this);
            HystrixCommandResponseFromCache fromCache2 = (HystrixCommandResponseFromCache)this.requestCache.putIfAbsent(cacheKey, toCache);
            if (fromCache2 != null) {
                toCache.unsubscribe();
                this.isResponseFromCache = true;
                return this.handleRequestCacheHitAndEmitValues(fromCache2, _cmd);
            }
            afterCache = toCache.toObservable();
        } else {
            afterCache = hystrixObservable;
        }
        return afterCache.doOnTerminate(terminateCommandCleanup).doOnUnsubscribe(unsubscribeCommandCleanup).doOnCompleted(fireOnCompletedHook);
    }

    private Observable<R> applyHystrixSemantics(AbstractCommand<R> _cmd) {
        this.executionHook.onStart(_cmd);
        if (this.circuitBreaker.allowRequest()) {
            final TryableSemaphore executionSemaphore = this.getExecutionSemaphore();
            final AtomicBoolean semaphoreHasBeenReleased = new AtomicBoolean(false);
            Action0 singleSemaphoreRelease = new Action0(){

                public void call() {
                    if (semaphoreHasBeenReleased.compareAndSet(false, true)) {
                        executionSemaphore.release();
                    }
                }
            };
            Action1<Throwable> markExceptionThrown = new Action1<Throwable>(){

                public void call(Throwable t) {
                    AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.EXCEPTION_THROWN, AbstractCommand.this.commandKey);
                }
            };
            if (executionSemaphore.tryAcquire()) {
                try {
                    this.executionResult = this.executionResult.setInvocationStartTime(System.currentTimeMillis());
                    return this.executeCommandAndObserve(_cmd).doOnError((Action1)markExceptionThrown).doOnTerminate(singleSemaphoreRelease).doOnUnsubscribe(singleSemaphoreRelease);
                }
                catch (RuntimeException e) {
                    return Observable.error((Throwable)e);
                }
            }
            return this.handleSemaphoreRejectionViaFallback();
        }
        return this.handleShortCircuitViaFallback();
    }

    private Observable<R> executeCommandAndObserve(AbstractCommand<R> _cmd) {
        final HystrixRequestContext currentRequestContext = HystrixRequestContext.getContextForCurrentThread();
        Action1 markEmits = new Action1<R>(){

            public void call(R r) {
                if (AbstractCommand.this.shouldOutputOnNextEvents()) {
                    AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvent(HystrixEventType.EMIT);
                    AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.EMIT, AbstractCommand.this.commandKey);
                }
            }
        };
        Action0 markCompleted = new Action0(){

            public void call() {
                long latency = System.currentTimeMillis() - AbstractCommand.this.executionResult.getStartTimestamp();
                AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.SUCCESS, AbstractCommand.this.commandKey);
                AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvent((int)latency, HystrixEventType.SUCCESS);
                AbstractCommand.this.circuitBreaker.markSuccess();
                AbstractCommand.this.eventNotifier.markCommandExecution(AbstractCommand.this.getCommandKey(), AbstractCommand.this.properties.executionIsolationStrategy().get(), (int)latency, AbstractCommand.this.executionResult.getOrderedList());
            }
        };
        Func1 handleFallback = new Func1<Throwable, Observable<R>>(){

            public Observable<R> call(Throwable t) {
                Exception e = AbstractCommand.this.getExceptionFromThrowable(t);
                AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.setExecutionException(e);
                if (e instanceof RejectedExecutionException) {
                    return AbstractCommand.this.handleThreadPoolRejectionViaFallback(e);
                }
                if (t instanceof HystrixTimeoutException) {
                    return AbstractCommand.this.handleTimeoutViaFallback();
                }
                if (t instanceof HystrixBadRequestException) {
                    return AbstractCommand.this.handleBadRequestByEmittingError(e);
                }
                if (e instanceof HystrixBadRequestException) {
                    AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.BAD_REQUEST, AbstractCommand.this.commandKey);
                    return Observable.error((Throwable)e);
                }
                return AbstractCommand.this.handleFailureViaFallback(e);
            }
        };
        Action1 setRequestContext = new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> rNotification) {
                AbstractCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        };
        Observable execution = this.properties.executionTimeoutEnabled().get() != false ? this.executeCommandWithSpecifiedIsolation(_cmd).lift(new HystrixObservableTimeoutOperator<R>(_cmd)) : this.executeCommandWithSpecifiedIsolation(_cmd);
        return execution.doOnNext(markEmits).doOnCompleted(markCompleted).onErrorResumeNext(handleFallback).doOnEach(setRequestContext);
    }

    private Observable<R> executeCommandWithSpecifiedIsolation(final AbstractCommand<R> _cmd) {
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
            return Observable.defer((Func0)new Func0<Observable<R>>(){

                public Observable<R> call() {
                    AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.setExecutionOccurred();
                    if (!AbstractCommand.this.commandState.compareAndSet(CommandState.OBSERVABLE_CHAIN_CREATED, CommandState.USER_CODE_EXECUTED)) {
                        return Observable.error((Throwable)new IllegalStateException("execution attempted while in state : " + AbstractCommand.this.commandState.get().name()));
                    }
                    AbstractCommand.this.metrics.markCommandStart(AbstractCommand.this.commandKey, AbstractCommand.this.threadPoolKey, HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
                    if (AbstractCommand.this.isCommandTimedOut.get() == TimedOutStatus.TIMED_OUT) {
                        return Observable.error((Throwable)new RuntimeException("timed out before executing run()"));
                    }
                    if (AbstractCommand.this.threadState.compareAndSet(ThreadState.NOT_USING_THREAD, ThreadState.STARTED)) {
                        HystrixCounters.incrementGlobalConcurrentThreads();
                        AbstractCommand.this.threadPool.markThreadExecution();
                        AbstractCommand.this.endCurrentThreadExecutingCommand = Hystrix.startCurrentThreadExecutingCommand(AbstractCommand.this.getCommandKey());
                        AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.setExecutedInThread();
                        try {
                            AbstractCommand.this.executionHook.onThreadStart(_cmd);
                            AbstractCommand.this.executionHook.onRunStart(_cmd);
                            AbstractCommand.this.executionHook.onExecutionStart(_cmd);
                            return AbstractCommand.this.getUserExecutionObservable(_cmd);
                        }
                        catch (Throwable ex) {
                            return Observable.error((Throwable)ex);
                        }
                    }
                    return Observable.error((Throwable)new RuntimeException("unsubscribed before executing run()"));
                }
            }).doOnTerminate(new Action0(){

                public void call() {
                    if (AbstractCommand.this.threadState.compareAndSet(ThreadState.STARTED, ThreadState.TERMINAL)) {
                        AbstractCommand.this.handleThreadEnd(_cmd);
                    }
                    if (AbstractCommand.this.threadState.compareAndSet(ThreadState.NOT_USING_THREAD, ThreadState.TERMINAL)) {
                        // empty if block
                    }
                }
            }).doOnUnsubscribe(new Action0(){

                public void call() {
                    if (AbstractCommand.this.threadState.compareAndSet(ThreadState.STARTED, ThreadState.UNSUBSCRIBED)) {
                        AbstractCommand.this.handleThreadEnd(_cmd);
                    }
                    if (AbstractCommand.this.threadState.compareAndSet(ThreadState.NOT_USING_THREAD, ThreadState.UNSUBSCRIBED)) {
                        // empty if block
                    }
                }
            }).subscribeOn(this.threadPool.getScheduler(new Func0<Boolean>(){

                public Boolean call() {
                    return AbstractCommand.this.properties.executionIsolationThreadInterruptOnTimeout().get() != false && _cmd.isCommandTimedOut.get().equals((Object)TimedOutStatus.TIMED_OUT);
                }
            }));
        }
        return Observable.defer((Func0)new Func0<Observable<R>>(){

            public Observable<R> call() {
                AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.setExecutionOccurred();
                if (!AbstractCommand.this.commandState.compareAndSet(CommandState.OBSERVABLE_CHAIN_CREATED, CommandState.USER_CODE_EXECUTED)) {
                    return Observable.error((Throwable)new IllegalStateException("execution attempted while in state : " + AbstractCommand.this.commandState.get().name()));
                }
                AbstractCommand.this.metrics.markCommandStart(AbstractCommand.this.commandKey, AbstractCommand.this.threadPoolKey, HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
                AbstractCommand.this.endCurrentThreadExecutingCommand = Hystrix.startCurrentThreadExecutingCommand(AbstractCommand.this.getCommandKey());
                try {
                    AbstractCommand.this.executionHook.onRunStart(_cmd);
                    AbstractCommand.this.executionHook.onExecutionStart(_cmd);
                    return AbstractCommand.this.getUserExecutionObservable(_cmd);
                }
                catch (Throwable ex) {
                    return Observable.error((Throwable)ex);
                }
            }
        });
    }

    private Observable<R> getFallbackOrThrowException(final AbstractCommand<R> _cmd, HystrixEventType eventType, final HystrixRuntimeException.FailureType failureType, final String message, final Exception originalException) {
        final HystrixRequestContext requestContext = HystrixRequestContext.getContextForCurrentThread();
        long latency = System.currentTimeMillis() - this.executionResult.getStartTimestamp();
        this.executionResult = this.executionResult.addEvent((int)latency, eventType);
        if (this.isUnrecoverable(originalException)) {
            Exception e = originalException;
            logger.error("Unrecoverable Error for HystrixCommand so will throw HystrixRuntimeException and not apply fallback. ", (Throwable)e);
            e = this.wrapWithOnErrorHook(failureType, e);
            return Observable.error((Throwable)new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and encountered unrecoverable error.", e, null));
        }
        if (this.isRecoverableError(originalException)) {
            logger.warn("Recovered from java.lang.Error by serving Hystrix fallback", (Throwable)originalException);
        }
        if (this.properties.fallbackEnabled().get().booleanValue()) {
            Action1 setRequestContext = new Action1<Notification<? super R>>(){

                public void call(Notification<? super R> rNotification) {
                    AbstractCommand.setRequestContextIfNeeded(requestContext);
                }
            };
            Action1 markFallbackEmit = new Action1<R>(){

                public void call(R r) {
                    if (AbstractCommand.this.shouldOutputOnNextEvents()) {
                        AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvent(HystrixEventType.FALLBACK_EMIT);
                        AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.FALLBACK_EMIT, AbstractCommand.this.commandKey);
                    }
                }
            };
            Action0 markFallbackCompleted = new Action0(){

                public void call() {
                    long latency = System.currentTimeMillis() - AbstractCommand.this.executionResult.getStartTimestamp();
                    AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.FALLBACK_SUCCESS, AbstractCommand.this.commandKey);
                    AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvent((int)latency, HystrixEventType.FALLBACK_SUCCESS);
                }
            };
            Func1 handleFallbackError = new Func1<Throwable, Observable<R>>(){

                public Observable<R> call(Throwable t) {
                    Exception e = originalException;
                    Exception fe = AbstractCommand.this.getExceptionFromThrowable(t);
                    if (fe instanceof UnsupportedOperationException) {
                        long latency = System.currentTimeMillis() - AbstractCommand.this.executionResult.getStartTimestamp();
                        logger.debug("No fallback for HystrixCommand. ", (Throwable)fe);
                        AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.FALLBACK_MISSING, AbstractCommand.this.commandKey);
                        AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvent((int)latency, HystrixEventType.FALLBACK_MISSING);
                        e = AbstractCommand.this.wrapWithOnErrorHook(failureType, e);
                        return Observable.error((Throwable)new HystrixRuntimeException(failureType, _cmd.getClass(), AbstractCommand.this.getLogMessagePrefix() + " " + message + " and no fallback available.", e, (Throwable)fe));
                    }
                    long latency = System.currentTimeMillis() - AbstractCommand.this.executionResult.getStartTimestamp();
                    logger.debug("HystrixCommand execution " + failureType.name() + " and fallback failed.", (Throwable)fe);
                    AbstractCommand.this.eventNotifier.markEvent(HystrixEventType.FALLBACK_FAILURE, AbstractCommand.this.commandKey);
                    AbstractCommand.this.executionResult = AbstractCommand.this.executionResult.addEvent((int)latency, HystrixEventType.FALLBACK_FAILURE);
                    e = AbstractCommand.this.wrapWithOnErrorHook(failureType, e);
                    return Observable.error((Throwable)new HystrixRuntimeException(failureType, _cmd.getClass(), AbstractCommand.this.getLogMessagePrefix() + " " + message + " and fallback failed.", e, (Throwable)fe));
                }
            };
            final TryableSemaphore fallbackSemaphore = this.getFallbackSemaphore();
            final AtomicBoolean semaphoreHasBeenReleased = new AtomicBoolean(false);
            Action0 singleSemaphoreRelease = new Action0(){

                public void call() {
                    if (semaphoreHasBeenReleased.compareAndSet(false, true)) {
                        fallbackSemaphore.release();
                    }
                }
            };
            if (fallbackSemaphore.tryAcquire()) {
                Observable<R> fallbackExecutionChain;
                try {
                    if (AbstractCommand.isFallbackUserSupplied(this)) {
                        this.executionHook.onFallbackStart(this);
                        fallbackExecutionChain = this.getFallbackObservable();
                    } else {
                        fallbackExecutionChain = this.getFallbackObservable();
                    }
                }
                catch (Throwable ex) {
                    fallbackExecutionChain = Observable.error((Throwable)ex);
                }
                return fallbackExecutionChain.doOnEach(setRequestContext).lift((Observable.Operator)new FallbackHookApplication(_cmd)).lift((Observable.Operator)new DeprecatedOnFallbackHookApplication(_cmd)).doOnNext(markFallbackEmit).doOnCompleted(markFallbackCompleted).onErrorResumeNext(handleFallbackError).doOnTerminate(singleSemaphoreRelease).doOnUnsubscribe(singleSemaphoreRelease);
            }
            return this.handleFallbackRejectionByEmittingError();
        }
        return this.handleFallbackDisabledByEmittingError(originalException, failureType, message);
    }

    private Observable<R> getUserExecutionObservable(AbstractCommand<R> _cmd) {
        Observable userObservable;
        try {
            userObservable = this.getExecutionObservable();
        }
        catch (Throwable ex) {
            userObservable = Observable.error((Throwable)ex);
        }
        return userObservable.lift((Observable.Operator)new ExecutionHookApplication(_cmd)).lift((Observable.Operator)new DeprecatedOnRunHookApplication(_cmd));
    }

    private Observable<R> handleRequestCacheHitAndEmitValues(HystrixCommandResponseFromCache<R> fromCache, final AbstractCommand<R> _cmd) {
        try {
            this.executionHook.onCacheHit(this);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onCacheHit", hookEx);
        }
        return fromCache.toObservableWithStateCopiedInto(this).doOnTerminate(new Action0(){

            public void call() {
                if (AbstractCommand.this.commandState.compareAndSet(CommandState.OBSERVABLE_CHAIN_CREATED, CommandState.TERMINAL)) {
                    AbstractCommand.this.cleanUpAfterResponseFromCache(_cmd, false);
                } else if (AbstractCommand.this.commandState.compareAndSet(CommandState.USER_CODE_EXECUTED, CommandState.TERMINAL)) {
                    AbstractCommand.this.cleanUpAfterResponseFromCache(_cmd, true);
                }
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                if (AbstractCommand.this.commandState.compareAndSet(CommandState.OBSERVABLE_CHAIN_CREATED, CommandState.UNSUBSCRIBED)) {
                    AbstractCommand.this.cleanUpAfterResponseFromCache(_cmd, false);
                } else if (AbstractCommand.this.commandState.compareAndSet(CommandState.USER_CODE_EXECUTED, CommandState.UNSUBSCRIBED)) {
                    AbstractCommand.this.cleanUpAfterResponseFromCache(_cmd, true);
                }
            }
        });
    }

    private void cleanUpAfterResponseFromCache(AbstractCommand<R> _cmd, boolean commandExecutionStarted) {
        Reference<HystrixTimer.TimerListener> tl = this.timeoutTimer.get();
        if (tl != null) {
            tl.clear();
        }
        long latency = System.currentTimeMillis() - this.commandStartTimestamp;
        this.executionResult = this.executionResult.addEvent(-1, HystrixEventType.RESPONSE_FROM_CACHE).markUserThreadCompletion(latency).setNotExecutedInThread();
        ExecutionResult cacheOnlyForMetrics = ExecutionResult.from(HystrixEventType.RESPONSE_FROM_CACHE).markUserThreadCompletion(latency);
        this.metrics.markCommandDone(cacheOnlyForMetrics, this.commandKey, this.threadPoolKey, commandExecutionStarted);
        this.eventNotifier.markEvent(HystrixEventType.RESPONSE_FROM_CACHE, this.commandKey);
    }

    private void handleCommandEnd(AbstractCommand _cmd, boolean commandExecutionStarted) {
        Reference<HystrixTimer.TimerListener> tl = this.timeoutTimer.get();
        if (tl != null) {
            tl.clear();
        }
        long userThreadLatency = System.currentTimeMillis() - this.commandStartTimestamp;
        this.executionResult = this.executionResult.markUserThreadCompletion((int)userThreadLatency);
        if (this.executionResultAtTimeOfCancellation == null) {
            this.metrics.markCommandDone(this.executionResult, this.commandKey, this.threadPoolKey, commandExecutionStarted);
        } else {
            this.metrics.markCommandDone(this.executionResultAtTimeOfCancellation, this.commandKey, this.threadPoolKey, commandExecutionStarted);
        }
        if (this.endCurrentThreadExecutingCommand != null) {
            this.endCurrentThreadExecutingCommand.call();
        }
    }

    private Observable<R> handleSemaphoreRejectionViaFallback() {
        RuntimeException semaphoreRejectionException = new RuntimeException("could not acquire a semaphore for execution");
        this.executionResult = this.executionResult.setExecutionException(semaphoreRejectionException);
        this.eventNotifier.markEvent(HystrixEventType.SEMAPHORE_REJECTED, this.commandKey);
        logger.debug("HystrixCommand Execution Rejection by Semaphore.");
        return this.getFallbackOrThrowException(this, HystrixEventType.SEMAPHORE_REJECTED, HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION, "could not acquire a semaphore for execution", semaphoreRejectionException);
    }

    private Observable<R> handleShortCircuitViaFallback() {
        this.eventNotifier.markEvent(HystrixEventType.SHORT_CIRCUITED, this.commandKey);
        RuntimeException shortCircuitException = new RuntimeException("Hystrix circuit short-circuited and is OPEN");
        this.executionResult = this.executionResult.setExecutionException(shortCircuitException);
        try {
            return this.getFallbackOrThrowException(this, HystrixEventType.SHORT_CIRCUITED, HystrixRuntimeException.FailureType.SHORTCIRCUIT, "short-circuited", shortCircuitException);
        }
        catch (Exception e) {
            return Observable.error((Throwable)e);
        }
    }

    private Observable<R> handleThreadPoolRejectionViaFallback(Exception underlying) {
        this.eventNotifier.markEvent(HystrixEventType.THREAD_POOL_REJECTED, this.commandKey);
        this.threadPool.markThreadRejection();
        return this.getFallbackOrThrowException(this, HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "could not be queued for execution", underlying);
    }

    private Observable<R> handleTimeoutViaFallback() {
        return this.getFallbackOrThrowException(this, HystrixEventType.TIMEOUT, HystrixRuntimeException.FailureType.TIMEOUT, "timed-out", new TimeoutException());
    }

    private Observable<R> handleBadRequestByEmittingError(Exception underlying) {
        Exception toEmit = underlying;
        try {
            long executionLatency = System.currentTimeMillis() - this.executionResult.getStartTimestamp();
            this.eventNotifier.markEvent(HystrixEventType.BAD_REQUEST, this.commandKey);
            this.executionResult = this.executionResult.addEvent((int)executionLatency, HystrixEventType.BAD_REQUEST);
            Exception decorated = this.executionHook.onError(this, HystrixRuntimeException.FailureType.BAD_REQUEST_EXCEPTION, underlying);
            if (decorated instanceof HystrixBadRequestException) {
                toEmit = decorated;
            } else {
                logger.warn("ExecutionHook.onError returned an exception that was not an instance of HystrixBadRequestException so will be ignored.", (Throwable)decorated);
            }
        }
        catch (Exception hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onError", (Throwable)hookEx);
        }
        return Observable.error((Throwable)toEmit);
    }

    private Observable<R> handleFailureViaFallback(Exception underlying) {
        logger.debug("Error executing HystrixCommand.run(). Proceeding to fallback logic ...", (Throwable)underlying);
        this.eventNotifier.markEvent(HystrixEventType.FAILURE, this.commandKey);
        this.executionResult = this.executionResult.setException(underlying);
        return this.getFallbackOrThrowException(this, HystrixEventType.FAILURE, HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, "failed", underlying);
    }

    private Observable<R> handleFallbackRejectionByEmittingError() {
        long latencyWithFallback = System.currentTimeMillis() - this.executionResult.getStartTimestamp();
        this.eventNotifier.markEvent(HystrixEventType.FALLBACK_REJECTION, this.commandKey);
        this.executionResult = this.executionResult.addEvent((int)latencyWithFallback, HystrixEventType.FALLBACK_REJECTION);
        logger.debug("HystrixCommand Fallback Rejection.");
        return Observable.error((Throwable)new HystrixRuntimeException(HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_FALLBACK, this.getClass(), this.getLogMessagePrefix() + " fallback execution rejected.", null, null));
    }

    private Observable<R> handleFallbackDisabledByEmittingError(Exception underlying, HystrixRuntimeException.FailureType failureType, String message) {
        logger.debug("Fallback disabled for HystrixCommand so will throw HystrixRuntimeException. ", (Throwable)underlying);
        Exception wrapped = this.wrapWithOnErrorHook(failureType, underlying);
        return Observable.error((Throwable)new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and fallback disabled.", wrapped, null));
    }

    private boolean isUnrecoverable(Throwable t) {
        if (t != null && t.getCause() != null) {
            Throwable cause = t.getCause();
            if (cause instanceof StackOverflowError) {
                return true;
            }
            if (cause instanceof VirtualMachineError) {
                return true;
            }
            if (cause instanceof ThreadDeath) {
                return true;
            }
            if (cause instanceof LinkageError) {
                return true;
            }
        }
        return false;
    }

    private boolean isRecoverableError(Throwable t) {
        Throwable cause;
        if (t != null && t.getCause() != null && (cause = t.getCause()) instanceof Error) {
            return !this.isUnrecoverable(t);
        }
        return false;
    }

    protected void handleThreadEnd(AbstractCommand<R> _cmd) {
        HystrixCounters.decrementGlobalConcurrentThreads();
        this.threadPool.markThreadCompletion();
        try {
            this.executionHook.onThreadComplete(_cmd);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onThreadComplete", hookEx);
        }
    }

    protected boolean shouldOutputOnNextEvents() {
        return false;
    }

    private static void setRequestContextIfNeeded(HystrixRequestContext currentRequestContext) {
        if (!HystrixRequestContext.isCurrentThreadInitialized()) {
            HystrixRequestContext.setContextOnCurrentThread(currentRequestContext);
        }
    }

    protected TryableSemaphore getFallbackSemaphore() {
        if (this.fallbackSemaphoreOverride == null) {
            TryableSemaphore _s = fallbackSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                fallbackSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphoreActual(this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests()));
                return fallbackSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.fallbackSemaphoreOverride;
    }

    protected TryableSemaphore getExecutionSemaphore() {
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)) {
            if (this.executionSemaphoreOverride == null) {
                TryableSemaphore _s = executionSemaphorePerCircuit.get(this.commandKey.name());
                if (_s == null) {
                    executionSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphoreActual(this.properties.executionIsolationSemaphoreMaxConcurrentRequests()));
                    return executionSemaphorePerCircuit.get(this.commandKey.name());
                }
                return _s;
            }
            return this.executionSemaphoreOverride;
        }
        return TryableSemaphoreNoOp.DEFAULT;
    }

    protected abstract String getFallbackMethodName();

    static boolean isFallbackUserSupplied(AbstractCommand<?> cmd) {
        Boolean toInsertIntoMap;
        HystrixCommandKey commandKey = cmd.commandKey;
        Boolean containsFromMap = commandContainsFallback.get(commandKey);
        if (containsFromMap != null) {
            return containsFromMap;
        }
        try {
            cmd.getClass().getDeclaredMethod(cmd.getFallbackMethodName(), new Class[0]);
            toInsertIntoMap = true;
        }
        catch (NoSuchMethodException nsme) {
            toInsertIntoMap = false;
        }
        commandContainsFallback.put(commandKey, toInsertIntoMap);
        return toInsertIntoMap;
    }

    @Override
    public HystrixCommandGroupKey getCommandGroup() {
        return this.commandGroup;
    }

    @Override
    public HystrixCommandKey getCommandKey() {
        return this.commandKey;
    }

    @Override
    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    HystrixCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public HystrixCommandMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HystrixCommandProperties getProperties() {
        return this.properties;
    }

    private Exception wrapWithOnExecutionErrorHook(Throwable t) {
        Exception e = this.getExceptionFromThrowable(t);
        try {
            return this.executionHook.onExecutionError(this, e);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onExecutionError", hookEx);
            return e;
        }
    }

    private Exception wrapWithOnFallbackErrorHook(Throwable t) {
        Exception e = this.getExceptionFromThrowable(t);
        try {
            if (AbstractCommand.isFallbackUserSupplied(this)) {
                return this.executionHook.onFallbackError(this, e);
            }
            return e;
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onFallbackError", hookEx);
            return e;
        }
    }

    private Exception wrapWithOnErrorHook(HystrixRuntimeException.FailureType failureType, Throwable t) {
        Exception e = this.getExceptionFromThrowable(t);
        try {
            return this.executionHook.onError(this, failureType, e);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onError", hookEx);
            return e;
        }
    }

    private R wrapWithOnExecutionEmitHook(R r) {
        try {
            return this.executionHook.onExecutionEmit(this, r);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onExecutionEmit", hookEx);
            return r;
        }
    }

    private R wrapWithOnFallbackEmitHook(R r) {
        try {
            return this.executionHook.onFallbackEmit(this, r);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onFallbackEmit", hookEx);
            return r;
        }
    }

    private R wrapWithOnEmitHook(R r) {
        try {
            return this.executionHook.onEmit(this, r);
        }
        catch (Throwable hookEx) {
            logger.warn("Error calling HystrixCommandExecutionHook.onEmit", hookEx);
            return r;
        }
    }

    protected RuntimeException decomposeException(Exception e) {
        if (e instanceof IllegalStateException) {
            return (IllegalStateException)e;
        }
        if (e instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e;
        }
        if (e.getCause() instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e.getCause();
        }
        if (e instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e;
        }
        if (e.getCause() instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e.getCause();
        }
        String message = this.getLogMessagePrefix() + " failed while executing.";
        logger.debug(message, (Throwable)e);
        return new HystrixRuntimeException(HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, this.getClass(), message, e, null);
    }

    protected String getCacheKey() {
        return null;
    }

    @Override
    public String getPublicCacheKey() {
        return this.getCacheKey();
    }

    protected boolean isRequestCachingEnabled() {
        return this.properties.requestCacheEnabled().get() != false && this.getCacheKey() != null;
    }

    protected String getLogMessagePrefix() {
        return this.getCommandKey().name();
    }

    @Override
    public boolean isCircuitBreakerOpen() {
        return this.properties.circuitBreakerForceOpen().get() != false || this.properties.circuitBreakerForceClosed().get() == false && this.circuitBreaker.isOpen();
    }

    @Override
    public boolean isExecutionComplete() {
        return this.commandState.get().equals((Object)CommandState.TERMINAL);
    }

    @Override
    public boolean isExecutedInThread() {
        return this.getCommandResult().isExecutedInThread();
    }

    @Override
    public boolean isSuccessfulExecution() {
        return this.getCommandResult().getEventCounts().contains(HystrixEventType.SUCCESS);
    }

    @Override
    public boolean isFailedExecution() {
        return this.getCommandResult().getEventCounts().contains(HystrixEventType.FAILURE);
    }

    @Override
    public Throwable getFailedExecutionException() {
        return this.executionResult.getException();
    }

    public Throwable getExecutionException() {
        return this.executionResult.getExecutionException();
    }

    @Override
    public boolean isResponseFromFallback() {
        return this.getCommandResult().getEventCounts().contains(HystrixEventType.FALLBACK_SUCCESS);
    }

    @Override
    public boolean isResponseTimedOut() {
        return this.getCommandResult().getEventCounts().contains(HystrixEventType.TIMEOUT);
    }

    @Override
    public boolean isResponseShortCircuited() {
        return this.getCommandResult().getEventCounts().contains(HystrixEventType.SHORT_CIRCUITED);
    }

    @Override
    public boolean isResponseFromCache() {
        return this.isResponseFromCache;
    }

    @Override
    public boolean isResponseSemaphoreRejected() {
        return this.getCommandResult().isResponseSemaphoreRejected();
    }

    @Override
    public boolean isResponseThreadPoolRejected() {
        return this.getCommandResult().isResponseThreadPoolRejected();
    }

    @Override
    public boolean isResponseRejected() {
        return this.getCommandResult().isResponseRejected();
    }

    @Override
    public List<HystrixEventType> getExecutionEvents() {
        return this.getCommandResult().getOrderedList();
    }

    private ExecutionResult getCommandResult() {
        ExecutionResult resultToReturn = this.executionResultAtTimeOfCancellation == null ? this.executionResult : this.executionResultAtTimeOfCancellation;
        if (this.isResponseFromCache) {
            resultToReturn = resultToReturn.addEvent(HystrixEventType.RESPONSE_FROM_CACHE);
        }
        return resultToReturn;
    }

    @Override
    public int getNumberEmissions() {
        return this.getCommandResult().getEventCounts().getCount(HystrixEventType.EMIT);
    }

    @Override
    public int getNumberFallbackEmissions() {
        return this.getCommandResult().getEventCounts().getCount(HystrixEventType.FALLBACK_EMIT);
    }

    @Override
    public int getNumberCollapsed() {
        return this.getCommandResult().getEventCounts().getCount(HystrixEventType.COLLAPSED);
    }

    @Override
    public HystrixCollapserKey getOriginatingCollapserKey() {
        return this.executionResult.getCollapserKey();
    }

    @Override
    public int getExecutionTimeInMilliseconds() {
        return this.getCommandResult().getExecutionLatency();
    }

    @Override
    public long getCommandRunStartTimeInNanos() {
        return this.executionResult.getCommandRunStartTimeInNanos();
    }

    @Override
    public ExecutionResult.EventCounts getEventCounts() {
        return this.getCommandResult().getEventCounts();
    }

    protected Exception getExceptionFromThrowable(Throwable t) {
        Exception e = t instanceof Exception ? (Exception)t : new Exception("Throwable caught while executing.", t);
        return e;
    }

    private static class ExecutionHookDeprecationWrapper
    extends HystrixCommandExecutionHook {
        private final HystrixCommandExecutionHook actual;

        ExecutionHookDeprecationWrapper(HystrixCommandExecutionHook actual) {
            this.actual = actual;
        }

        @Override
        public <T> T onEmit(HystrixInvokable<T> commandInstance, T value) {
            return this.actual.onEmit(commandInstance, value);
        }

        @Override
        public <T> void onSuccess(HystrixInvokable<T> commandInstance) {
            this.actual.onSuccess(commandInstance);
        }

        @Override
        public <T> void onExecutionStart(HystrixInvokable<T> commandInstance) {
            this.actual.onExecutionStart(commandInstance);
        }

        @Override
        public <T> T onExecutionEmit(HystrixInvokable<T> commandInstance, T value) {
            return this.actual.onExecutionEmit(commandInstance, value);
        }

        @Override
        public <T> Exception onExecutionError(HystrixInvokable<T> commandInstance, Exception e) {
            return this.actual.onExecutionError(commandInstance, e);
        }

        @Override
        public <T> void onExecutionSuccess(HystrixInvokable<T> commandInstance) {
            this.actual.onExecutionSuccess(commandInstance);
        }

        @Override
        public <T> T onFallbackEmit(HystrixInvokable<T> commandInstance, T value) {
            return this.actual.onFallbackEmit(commandInstance, value);
        }

        @Override
        public <T> void onFallbackSuccess(HystrixInvokable<T> commandInstance) {
            this.actual.onFallbackSuccess(commandInstance);
        }

        @Override
        @Deprecated
        public <T> void onRunStart(HystrixCommand<T> commandInstance) {
            this.actual.onRunStart(commandInstance);
        }

        @Override
        public <T> void onRunStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onRunStart(c);
            }
            this.actual.onRunStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onRunSuccess(HystrixCommand<T> commandInstance, T response) {
            return this.actual.onRunSuccess(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> T onRunSuccess(HystrixInvokable<T> commandInstance, T response) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                response = this.onRunSuccess(c, response);
            }
            return this.actual.onRunSuccess(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> Exception onRunError(HystrixCommand<T> commandInstance, Exception e) {
            return this.actual.onRunError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> Exception onRunError(HystrixInvokable<T> commandInstance, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onRunError(c, e);
            }
            return this.actual.onRunError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> void onFallbackStart(HystrixCommand<T> commandInstance) {
            this.actual.onFallbackStart(commandInstance);
        }

        @Override
        public <T> void onFallbackStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onFallbackStart(c);
            }
            this.actual.onFallbackStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onFallbackSuccess(HystrixCommand<T> commandInstance, T fallbackResponse) {
            return this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
        }

        @Override
        @Deprecated
        public <T> T onFallbackSuccess(HystrixInvokable<T> commandInstance, T fallbackResponse) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                fallbackResponse = this.onFallbackSuccess(c, fallbackResponse);
            }
            return this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
        }

        @Override
        @Deprecated
        public <T> Exception onFallbackError(HystrixCommand<T> commandInstance, Exception e) {
            return this.actual.onFallbackError(commandInstance, e);
        }

        @Override
        public <T> Exception onFallbackError(HystrixInvokable<T> commandInstance, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onFallbackError(c, e);
            }
            return this.actual.onFallbackError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> void onStart(HystrixCommand<T> commandInstance) {
            this.actual.onStart(commandInstance);
        }

        @Override
        public <T> void onStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onStart(c);
            }
            this.actual.onStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onComplete(HystrixCommand<T> commandInstance, T response) {
            return this.actual.onComplete(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> T onComplete(HystrixInvokable<T> commandInstance, T response) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                response = this.onComplete(c, response);
            }
            return this.actual.onComplete(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> Exception onError(HystrixCommand<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
            return this.actual.onError(commandInstance, failureType, e);
        }

        @Override
        public <T> Exception onError(HystrixInvokable<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onError(c, failureType, e);
            }
            return this.actual.onError(commandInstance, failureType, e);
        }

        @Override
        @Deprecated
        public <T> void onThreadStart(HystrixCommand<T> commandInstance) {
            this.actual.onThreadStart(commandInstance);
        }

        @Override
        public <T> void onThreadStart(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onThreadStart(c);
            }
            this.actual.onThreadStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> void onThreadComplete(HystrixCommand<T> commandInstance) {
            this.actual.onThreadComplete(commandInstance);
        }

        @Override
        public <T> void onThreadComplete(HystrixInvokable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onThreadComplete(c);
            }
            this.actual.onThreadComplete(commandInstance);
        }

        @Override
        public <T> void onCacheHit(HystrixInvokable<T> commandInstance) {
            this.actual.onCacheHit(commandInstance);
        }

        private <T> HystrixCommand<T> getHystrixCommandFromAbstractIfApplicable(HystrixInvokable<T> commandInstance) {
            if (commandInstance instanceof HystrixCommand) {
                return (HystrixCommand)commandInstance;
            }
            return null;
        }
    }

    static interface TryableSemaphore {
        public boolean tryAcquire();

        public void release();

        public int getNumberOfPermitsUsed();
    }

    static class TryableSemaphoreNoOp
    implements TryableSemaphore {
        public static final TryableSemaphore DEFAULT = new TryableSemaphoreNoOp();

        TryableSemaphoreNoOp() {
        }

        @Override
        public boolean tryAcquire() {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public int getNumberOfPermitsUsed() {
            return 0;
        }
    }

    static class TryableSemaphoreActual
    implements TryableSemaphore {
        protected final HystrixProperty<Integer> numberOfPermits;
        private final AtomicInteger count = new AtomicInteger(0);

        public TryableSemaphoreActual(HystrixProperty<Integer> numberOfPermits) {
            this.numberOfPermits = numberOfPermits;
        }

        @Override
        public boolean tryAcquire() {
            int currentCount = this.count.incrementAndGet();
            if (currentCount > this.numberOfPermits.get()) {
                this.count.decrementAndGet();
                return false;
            }
            return true;
        }

        @Override
        public void release() {
            this.count.decrementAndGet();
        }

        @Override
        public int getNumberOfPermitsUsed() {
            return this.count.get();
        }
    }

    @Deprecated
    private class DeprecatedOnFallbackHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        DeprecatedOnFallbackHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    subscriber.onCompleted();
                }

                public void onError(Throwable t) {
                    subscriber.onError(t);
                }

                public void onNext(R r) {
                    try {
                        Object wrappedValue = AbstractCommand.this.executionHook.onFallbackSuccess(DeprecatedOnFallbackHookApplication.this.cmd, r);
                        subscriber.onNext(wrappedValue);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onFallbackSuccess", hookEx);
                        subscriber.onNext(r);
                    }
                }
            };
        }
    }

    @Deprecated
    private class DeprecatedOnRunHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        DeprecatedOnRunHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    subscriber.onCompleted();
                }

                public void onError(Throwable t) {
                    Exception e = AbstractCommand.this.getExceptionFromThrowable(t);
                    try {
                        Exception wrappedEx = AbstractCommand.this.executionHook.onRunError(DeprecatedOnRunHookApplication.this.cmd, e);
                        subscriber.onError((Throwable)wrappedEx);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onRunError", hookEx);
                        subscriber.onError((Throwable)e);
                    }
                }

                public void onNext(R r) {
                    try {
                        Object wrappedValue = AbstractCommand.this.executionHook.onRunSuccess(DeprecatedOnRunHookApplication.this.cmd, r);
                        subscriber.onNext(wrappedValue);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onRunSuccess", hookEx);
                        subscriber.onNext(r);
                    }
                }
            };
        }
    }

    private class FallbackHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        FallbackHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    try {
                        AbstractCommand.this.executionHook.onFallbackSuccess(FallbackHookApplication.this.cmd);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onFallbackSuccess", hookEx);
                    }
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    Exception wrappedEx = AbstractCommand.this.wrapWithOnFallbackErrorHook(e);
                    subscriber.onError((Throwable)wrappedEx);
                }

                public void onNext(R r) {
                    Object wrappedValue = AbstractCommand.this.wrapWithOnFallbackEmitHook(r);
                    subscriber.onNext(wrappedValue);
                }
            };
        }
    }

    private class ExecutionHookApplication
    implements Observable.Operator<R, R> {
        private final HystrixInvokable<R> cmd;

        ExecutionHookApplication(HystrixInvokable<R> cmd) {
            this.cmd = cmd;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> subscriber) {
            return new Subscriber<R>(subscriber){

                public void onCompleted() {
                    try {
                        AbstractCommand.this.executionHook.onExecutionSuccess(ExecutionHookApplication.this.cmd);
                    }
                    catch (Throwable hookEx) {
                        logger.warn("Error calling HystrixCommandExecutionHook.onExecutionSuccess", hookEx);
                    }
                    subscriber.onCompleted();
                }

                public void onError(Throwable e) {
                    Exception wrappedEx = AbstractCommand.this.wrapWithOnExecutionErrorHook(e);
                    subscriber.onError((Throwable)wrappedEx);
                }

                public void onNext(R r) {
                    Object wrappedValue = AbstractCommand.this.wrapWithOnExecutionEmitHook(r);
                    subscriber.onNext(wrappedValue);
                }
            };
        }
    }

    private static class HystrixObservableTimeoutOperator<R>
    implements Observable.Operator<R, R> {
        final AbstractCommand<R> originalCommand;

        public HystrixObservableTimeoutOperator(AbstractCommand<R> originalCommand) {
            this.originalCommand = originalCommand;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> child) {
            final CompositeSubscription s = new CompositeSubscription();
            child.add((Subscription)s);
            final HystrixContextRunnable timeoutRunnable = new HystrixContextRunnable(this.originalCommand.concurrencyStrategy, new Runnable(){

                @Override
                public void run() {
                    child.onError((Throwable)new HystrixTimeoutException());
                }
            });
            HystrixTimer.TimerListener listener = new HystrixTimer.TimerListener(){

                @Override
                public void tick() {
                    if (HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.TIMED_OUT)) {
                        HystrixObservableTimeoutOperator.this.originalCommand.eventNotifier.markEvent(HystrixEventType.TIMEOUT, HystrixObservableTimeoutOperator.this.originalCommand.commandKey);
                        s.unsubscribe();
                        timeoutRunnable.run();
                    }
                }

                @Override
                public int getIntervalTimeInMilliseconds() {
                    return HystrixObservableTimeoutOperator.this.originalCommand.properties.executionTimeoutInMilliseconds().get();
                }
            };
            final Reference<HystrixTimer.TimerListener> tl = HystrixTimer.getInstance().addTimerListener(listener);
            this.originalCommand.timeoutTimer.set(tl);
            Subscriber parent = new Subscriber<R>(){

                public void onCompleted() {
                    if (this.isNotTimedOut()) {
                        tl.clear();
                        child.onCompleted();
                    }
                }

                public void onError(Throwable e) {
                    if (this.isNotTimedOut()) {
                        tl.clear();
                        child.onError(e);
                    }
                }

                public void onNext(R v) {
                    if (this.isNotTimedOut()) {
                        child.onNext(v);
                    }
                }

                private boolean isNotTimedOut() {
                    return HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.get() == TimedOutStatus.COMPLETED || HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(TimedOutStatus.NOT_EXECUTED, TimedOutStatus.COMPLETED);
                }
            };
            s.add((Subscription)parent);
            return parent;
        }
    }

    protected static enum ThreadState {
        NOT_USING_THREAD,
        STARTED,
        UNSUBSCRIBED,
        TERMINAL;

    }

    protected static enum CommandState {
        NOT_STARTED,
        OBSERVABLE_CHAIN_CREATED,
        USER_CODE_EXECUTED,
        UNSUBSCRIBED,
        TERMINAL;

    }

    protected static enum TimedOutStatus {
        NOT_EXECUTED,
        COMPLETED,
        TIMED_OUT;

    }
}

