/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.netflix.hystrix.contrib.javanica.utils.MethodProvider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public final class AopUtils {
    private AopUtils() {
        throw new UnsupportedOperationException("It's prohibited to create instances of the class.");
    }

    public static Method getMethodFromTarget(JoinPoint joinPoint) {
        Method method = null;
        if (joinPoint.getSignature() instanceof MethodSignature) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            method = AopUtils.getDeclaredMethod(joinPoint.getTarget().getClass(), signature.getName(), AopUtils.getParameterTypes(joinPoint));
        }
        return method;
    }

    public static Method getMethodFromTarget(JoinPoint joinPoint, String methodName) {
        return AopUtils.getDeclaredMethod(joinPoint.getTarget().getClass(), methodName, AopUtils.getParameterTypes(joinPoint));
    }

    public static Class[] getParameterTypes(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        return method.getParameterTypes();
    }

    public static Method getDeclaredMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = type.getDeclaredMethod(methodName, parameterTypes);
            if (method.isBridge()) {
                method = MethodProvider.getInstance().unbride(method, type);
            }
        }
        catch (NoSuchMethodException e) {
            Class<?> superclass = type.getSuperclass();
            if (superclass != null) {
                method = AopUtils.getDeclaredMethod(superclass, methodName, parameterTypes);
            }
        }
        catch (ClassNotFoundException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return method;
    }

    public static <T extends Annotation> Optional<T> getAnnotation(JoinPoint joinPoint, Class<T> annotation) {
        return AopUtils.getAnnotation(joinPoint.getTarget().getClass(), annotation);
    }

    public static <T extends Annotation> Optional<T> getAnnotation(Class<?> type, Class<T> annotation) {
        Validate.notNull(annotation, (String)"annotation cannot be null", (Object[])new Object[0]);
        Validate.notNull(type, (String)"type cannot be null", (Object[])new Object[0]);
        for (Annotation ann : type.getDeclaredAnnotations()) {
            if (!ann.annotationType().equals(annotation)) continue;
            return Optional.of((Object)ann);
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null && !superType.equals(Object.class)) {
            return AopUtils.getAnnotation(superType, annotation);
        }
        return Optional.absent();
    }

    public static String getMethodInfo(Method m) {
        int i;
        StringBuilder info = new StringBuilder();
        info.append("Method signature:").append("\n");
        info.append(m.toGenericString()).append("\n");
        info.append("Declaring class:\n");
        info.append(m.getDeclaringClass().getCanonicalName()).append("\n");
        info.append("\nFlags:").append("\n");
        info.append("Bridge=").append(m.isBridge()).append("\n");
        info.append("Synthetic=").append(m.isSynthetic()).append("\n");
        info.append("Final=").append(Modifier.isFinal(m.getModifiers())).append("\n");
        info.append("Native=").append(Modifier.isNative(m.getModifiers())).append("\n");
        info.append("Synchronized=").append(Modifier.isSynchronized(m.getModifiers())).append("\n");
        info.append("Abstract=").append(Modifier.isAbstract(m.getModifiers())).append("\n");
        info.append("AccessLevel=").append(AopUtils.getAccessLevel(m.getModifiers())).append("\n");
        info.append("\nReturn Type: \n");
        info.append("ReturnType=").append(m.getReturnType()).append("\n");
        info.append("GenericReturnType=").append(m.getGenericReturnType()).append("\n");
        info.append("\nParameters:");
        Class<?>[] pType = m.getParameterTypes();
        Type[] gpType = m.getGenericParameterTypes();
        if (pType.length != 0) {
            info.append("\n");
        } else {
            info.append("empty\n");
        }
        for (int i2 = 0; i2 < pType.length; ++i2) {
            info.append("parameter [").append(i2).append("]:\n");
            info.append("ParameterType=").append(pType[i2]).append("\n");
            info.append("GenericParameterType=").append(gpType[i2]).append("\n");
        }
        info.append("\nExceptions:");
        Class<?>[] xType = m.getExceptionTypes();
        Type[] gxType = m.getGenericExceptionTypes();
        if (xType.length != 0) {
            info.append("\n");
        } else {
            info.append("empty\n");
        }
        for (i = 0; i < xType.length; ++i) {
            info.append("exception [").append(i).append("]:\n");
            info.append("ExceptionType=").append(xType[i]).append("\n");
            info.append("GenericExceptionType=").append(gxType[i]).append("\n");
        }
        info.append("\nAnnotations:");
        if (m.getAnnotations().length != 0) {
            info.append("\n");
        } else {
            info.append("empty\n");
        }
        for (i = 0; i < m.getAnnotations().length; ++i) {
            info.append("annotation[").append(i).append("]=").append(m.getAnnotations()[i]).append("\n");
        }
        return info.toString();
    }

    private static String getAccessLevel(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return "public";
        }
        if (Modifier.isProtected(modifiers)) {
            return "protected";
        }
        if (Modifier.isPrivate(modifiers)) {
            return "private";
        }
        return "default";
    }
}

