/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCollapser;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixException;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import com.netflix.hystrix.contrib.javanica.annotation.ObservableExecutionMode;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.closure.Closure;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;

@Immutable
public final class MetaHolder {
    private final HystrixCollapser hystrixCollapser;
    private final HystrixCommand hystrixCommand;
    private final DefaultProperties defaultProperties;
    private final Method method;
    private final Method cacheKeyMethod;
    private final Method ajcMethod;
    private final Method fallbackMethod;
    private final Object obj;
    private final Object proxyObj;
    private final Object[] args;
    private final Closure closure;
    private final String defaultGroupKey;
    private final String defaultCommandKey;
    private final String defaultCollapserKey;
    private final String defaultThreadPoolKey;
    private final ExecutionType executionType;
    private final boolean extendedFallback;
    private final ExecutionType collapserExecutionType;
    private final ExecutionType fallbackExecutionType;
    private final boolean fallback;
    private boolean extendedParentFallback;
    private final JoinPoint joinPoint;
    private final boolean observable;
    private final ObservableExecutionMode observableExecutionMode;
    private static final Function identityFun = new Function<Object, Object>(){

        @Nullable
        public Object apply(@Nullable Object input) {
            return input;
        }
    };

    private MetaHolder(Builder builder) {
        this.hystrixCommand = builder.hystrixCommand;
        this.method = builder.method;
        this.cacheKeyMethod = builder.cacheKeyMethod;
        this.fallbackMethod = builder.fallbackMethod;
        this.ajcMethod = builder.ajcMethod;
        this.obj = builder.obj;
        this.proxyObj = builder.proxyObj;
        this.args = builder.args;
        this.closure = builder.closure;
        this.defaultGroupKey = builder.defaultGroupKey;
        this.defaultCommandKey = builder.defaultCommandKey;
        this.defaultThreadPoolKey = builder.defaultThreadPoolKey;
        this.defaultCollapserKey = builder.defaultCollapserKey;
        this.defaultProperties = builder.defaultProperties;
        this.hystrixCollapser = builder.hystrixCollapser;
        this.executionType = builder.executionType;
        this.collapserExecutionType = builder.collapserExecutionType;
        this.fallbackExecutionType = builder.fallbackExecutionType;
        this.joinPoint = builder.joinPoint;
        this.extendedFallback = builder.extendedFallback;
        this.fallback = builder.fallback;
        this.extendedParentFallback = builder.extendedParentFallback;
        this.observable = builder.observable;
        this.observableExecutionMode = builder.observableExecutionMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HystrixCollapser getHystrixCollapser() {
        return this.hystrixCollapser;
    }

    public HystrixCommand getHystrixCommand() {
        return this.hystrixCommand;
    }

    public Method getMethod() {
        return this.method;
    }

    public Method getCacheKeyMethod() {
        return this.cacheKeyMethod;
    }

    public Method getAjcMethod() {
        return this.ajcMethod;
    }

    public Object getObj() {
        return this.obj;
    }

    public Object getProxyObj() {
        return this.proxyObj;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public ExecutionType getCollapserExecutionType() {
        return this.collapserExecutionType;
    }

    public Object[] getArgs() {
        return this.args != null ? Arrays.copyOf(this.args, this.args.length) : new Object[]{};
    }

    public String getCommandGroupKey() {
        return this.isCommandAnnotationPresent() ? this.get(this.hystrixCommand.groupKey(), this.defaultGroupKey) : "";
    }

    public String getDefaultGroupKey() {
        return this.defaultGroupKey;
    }

    public String getDefaultThreadPoolKey() {
        return this.defaultThreadPoolKey;
    }

    public String getCollapserKey() {
        return this.isCollapserAnnotationPresent() ? this.get(this.hystrixCollapser.collapserKey(), this.defaultCollapserKey) : "";
    }

    public String getCommandKey() {
        return this.isCommandAnnotationPresent() ? this.get(this.hystrixCommand.commandKey(), this.defaultCommandKey) : "";
    }

    public String getThreadPoolKey() {
        return this.isCommandAnnotationPresent() ? this.get(this.hystrixCommand.threadPoolKey(), this.defaultThreadPoolKey) : "";
    }

    public String getDefaultCommandKey() {
        return this.defaultCommandKey;
    }

    public String getDefaultCollapserKey() {
        return this.defaultCollapserKey;
    }

    public boolean hasDefaultProperties() {
        return this.defaultProperties != null;
    }

    public Optional<DefaultProperties> getDefaultProperties() {
        return Optional.fromNullable((Object)this.defaultProperties);
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public boolean isCollapserAnnotationPresent() {
        return this.hystrixCollapser != null;
    }

    public boolean isCommandAnnotationPresent() {
        return this.hystrixCommand != null;
    }

    public JoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public Method getFallbackMethod() {
        return this.fallbackMethod;
    }

    public boolean hasFallbackMethod() {
        return this.fallbackMethod != null;
    }

    public boolean isExtendedParentFallback() {
        return this.extendedParentFallback;
    }

    public boolean hasFallbackMethodCommand() {
        return this.fallbackMethod != null && this.fallbackMethod.isAnnotationPresent(HystrixCommand.class);
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public boolean isExtendedFallback() {
        return this.extendedFallback;
    }

    public List<Class<? extends Throwable>> getCommandIgnoreExceptions() {
        if (!this.isCommandAnnotationPresent()) {
            return Collections.emptyList();
        }
        return this.getOrDefault(new Supplier<List<Class<? extends Throwable>>>(){

            public List<Class<? extends Throwable>> get() {
                return ImmutableList.copyOf((Object[])MetaHolder.this.hystrixCommand.ignoreExceptions());
            }
        }, new Supplier<List<Class<? extends Throwable>>>(){

            public List<Class<? extends Throwable>> get() {
                return MetaHolder.this.hasDefaultProperties() ? ImmutableList.copyOf((Object[])MetaHolder.this.defaultProperties.ignoreExceptions()) : Collections.emptyList();
            }
        }, this.nonEmptyList());
    }

    public ExecutionType getFallbackExecutionType() {
        return this.fallbackExecutionType;
    }

    public List<HystrixProperty> getCommandProperties() {
        if (!this.isCommandAnnotationPresent()) {
            return Collections.emptyList();
        }
        return this.getOrDefault(new Supplier<List<HystrixProperty>>(){

            public List<HystrixProperty> get() {
                return ImmutableList.copyOf((Object[])MetaHolder.this.hystrixCommand.commandProperties());
            }
        }, new Supplier<List<HystrixProperty>>(){

            public List<HystrixProperty> get() {
                return MetaHolder.this.hasDefaultProperties() ? ImmutableList.copyOf((Object[])MetaHolder.this.defaultProperties.commandProperties()) : Collections.emptyList();
            }
        }, this.nonEmptyList());
    }

    public List<HystrixProperty> getCollapserProperties() {
        return this.isCollapserAnnotationPresent() ? ImmutableList.copyOf((Object[])this.hystrixCollapser.collapserProperties()) : Collections.emptyList();
    }

    public List<HystrixProperty> getThreadPoolProperties() {
        if (!this.isCommandAnnotationPresent()) {
            return Collections.emptyList();
        }
        return this.getOrDefault(new Supplier<List<HystrixProperty>>(){

            public List<HystrixProperty> get() {
                return ImmutableList.copyOf((Object[])MetaHolder.this.hystrixCommand.threadPoolProperties());
            }
        }, new Supplier<List<HystrixProperty>>(){

            public List<HystrixProperty> get() {
                return MetaHolder.this.hasDefaultProperties() ? ImmutableList.copyOf((Object[])MetaHolder.this.defaultProperties.threadPoolProperties()) : Collections.emptyList();
            }
        }, this.nonEmptyList());
    }

    public boolean isObservable() {
        return this.observable;
    }

    public ObservableExecutionMode getObservableExecutionMode() {
        return this.observableExecutionMode;
    }

    public boolean raiseHystrixExceptionsContains(HystrixException hystrixException) {
        return this.getRaiseHystrixExceptions().contains((Object)hystrixException);
    }

    public List<HystrixException> getRaiseHystrixExceptions() {
        return this.getOrDefault(new Supplier<List<HystrixException>>(){

            public List<HystrixException> get() {
                return ImmutableList.copyOf((Object[])MetaHolder.this.hystrixCommand.raiseHystrixExceptions());
            }
        }, new Supplier<List<HystrixException>>(){

            public List<HystrixException> get() {
                return MetaHolder.this.hasDefaultProperties() ? ImmutableList.copyOf((Object[])MetaHolder.this.defaultProperties.raiseHystrixExceptions()) : Collections.emptyList();
            }
        }, this.nonEmptyList());
    }

    private String get(String key, String defaultKey) {
        return StringUtils.isNotBlank((CharSequence)key) ? key : defaultKey;
    }

    private <T> Predicate<List<T>> nonEmptyList() {
        return new Predicate<List<T>>(){

            public boolean apply(@Nullable List<T> input) {
                return input != null && !input.isEmpty();
            }
        };
    }

    private <T> T getOrDefault(Supplier<T> source, Supplier<T> defaultChoice, Predicate<T> isDefined) {
        return this.getOrDefault(source, defaultChoice, isDefined, identityFun);
    }

    private <T> T getOrDefault(Supplier<T> source, Supplier<T> defaultChoice, Predicate<T> isDefined, Function<T, T> map) {
        Object res = source.get();
        if (!isDefined.apply(res)) {
            res = defaultChoice.get();
        }
        return (T)map.apply(res);
    }

    public static final class Builder {
        private static final Class<?>[] EMPTY_ARRAY_OF_TYPES = new Class[0];
        private HystrixCollapser hystrixCollapser;
        private HystrixCommand hystrixCommand;
        private DefaultProperties defaultProperties;
        private Method method;
        private Method cacheKeyMethod;
        private Method fallbackMethod;
        private Method ajcMethod;
        private Object obj;
        private Object proxyObj;
        private Closure closure;
        private Object[] args;
        private String defaultGroupKey;
        private String defaultCommandKey;
        private String defaultCollapserKey;
        private String defaultThreadPoolKey;
        private ExecutionType executionType;
        private ExecutionType collapserExecutionType;
        private ExecutionType fallbackExecutionType;
        private boolean extendedFallback;
        private boolean fallback;
        private boolean extendedParentFallback;
        private boolean observable;
        private JoinPoint joinPoint;
        private ObservableExecutionMode observableExecutionMode;

        public Builder hystrixCollapser(HystrixCollapser hystrixCollapser) {
            this.hystrixCollapser = hystrixCollapser;
            return this;
        }

        public Builder hystrixCommand(HystrixCommand hystrixCommand) {
            this.hystrixCommand = hystrixCommand;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder cacheKeyMethod(Method cacheKeyMethod) {
            this.cacheKeyMethod = cacheKeyMethod;
            return this;
        }

        public Builder fallbackMethod(Method fallbackMethod) {
            this.fallbackMethod = fallbackMethod;
            return this;
        }

        public Builder fallbackExecutionType(ExecutionType fallbackExecutionType) {
            this.fallbackExecutionType = fallbackExecutionType;
            return this;
        }

        public Builder fallback(boolean fallback) {
            this.fallback = fallback;
            return this;
        }

        public Builder extendedParentFallback(boolean extendedParentFallback) {
            this.extendedParentFallback = extendedParentFallback;
            return this;
        }

        public Builder ajcMethod(Method ajcMethod) {
            this.ajcMethod = ajcMethod;
            return this;
        }

        public Builder obj(Object obj) {
            this.obj = obj;
            return this;
        }

        public Builder proxyObj(Object proxy) {
            this.proxyObj = proxy;
            return this;
        }

        public Builder args(Object[] args) {
            this.args = args;
            return this;
        }

        public Builder closure(Closure closure) {
            this.closure = closure;
            return this;
        }

        public Builder executionType(ExecutionType executionType) {
            this.executionType = executionType;
            return this;
        }

        public Builder collapserExecutionType(ExecutionType collapserExecutionType) {
            this.collapserExecutionType = collapserExecutionType;
            return this;
        }

        public Builder defaultGroupKey(String defGroupKey) {
            this.defaultGroupKey = defGroupKey;
            return this;
        }

        public Builder defaultCommandKey(String defCommandKey) {
            this.defaultCommandKey = defCommandKey;
            return this;
        }

        public Builder defaultThreadPoolKey(String defaultThreadPoolKey) {
            this.defaultThreadPoolKey = defaultThreadPoolKey;
            return this;
        }

        public Builder defaultCollapserKey(String defCollapserKey) {
            this.defaultCollapserKey = defCollapserKey;
            return this;
        }

        public Builder defaultProperties(@Nullable DefaultProperties defaultProperties) {
            this.defaultProperties = defaultProperties;
            return this;
        }

        public Builder joinPoint(JoinPoint joinPoint) {
            this.joinPoint = joinPoint;
            return this;
        }

        public Builder extendedFallback(boolean extendedFallback) {
            this.extendedFallback = extendedFallback;
            return this;
        }

        public Builder observable(boolean observable) {
            this.observable = observable;
            return this;
        }

        public Builder observableExecutionMode(ObservableExecutionMode observableExecutionMode) {
            this.observableExecutionMode = observableExecutionMode;
            return this;
        }

        public MetaHolder build() {
            return new MetaHolder(this);
        }
    }
}

