/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.google.common.base.Predicate;
import com.netflix.infix.ValuePredicate;
import org.apache.commons.jxpath.JXPathContext;

public class PathValueEventFilter<T>
implements Predicate<T> {
    private String xpath;
    private ValuePredicate<T> predicate;

    public PathValueEventFilter(String path, ValuePredicate<T> predicate) {
        this.xpath = path;
        this.predicate = predicate;
    }

    public boolean apply(Object input) {
        JXPathContext jxpath = JXPathContext.newContext((Object)input);
        jxpath.setLenient(true);
        Object value = jxpath.getValue(this.xpath);
        return this.predicate.apply(value);
    }

    public String getXpath() {
        return this.xpath;
    }

    public ValuePredicate<?> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PathValueEventFilter [xpath=");
        builder.append(this.xpath);
        builder.append(", predicate=");
        builder.append(this.predicate);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predicate == null ? 0 : ((Object)this.predicate).hashCode());
        result = 31 * result + (this.xpath == null ? 0 : this.xpath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathValueEventFilter other = (PathValueEventFilter)obj;
        if (this.predicate == null ? other.predicate != null : !((Object)this.predicate).equals(other.predicate)) {
            return false;
        }
        return !(this.xpath == null ? other.xpath != null : !this.xpath.equals(other.xpath));
    }
}

