/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4.ssl;

import com.netflix.client.ssl.AbstractSslContextFactory;
import com.netflix.client.ssl.ClientSslSocketFactoryException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class KeyStoreAwareSocketFactory
extends SSLSocketFactory {
    private final KeyStore keyStore;
    private final KeyStore trustStore;

    public KeyStoreAwareSocketFactory(X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyStoreException {
        super(SSLContext.getDefault(), hostnameVerifier);
        this.keyStore = null;
        this.trustStore = null;
    }

    public KeyStoreAwareSocketFactory(AbstractSslContextFactory abstractFactory) throws ClientSslSocketFactoryException, NoSuchAlgorithmException {
        super(abstractFactory == null ? SSLContext.getDefault() : abstractFactory.getSSLContext());
        if (abstractFactory == null) {
            this.keyStore = null;
            this.trustStore = null;
        } else {
            this.keyStore = abstractFactory.getKeyStore();
            this.trustStore = abstractFactory.getTrustStore();
        }
    }

    public KeyStoreAwareSocketFactory(AbstractSslContextFactory abstractFactory, X509HostnameVerifier hostnameVerifier) throws ClientSslSocketFactoryException, NoSuchAlgorithmException {
        super(abstractFactory == null ? SSLContext.getDefault() : abstractFactory.getSSLContext(), hostnameVerifier);
        if (abstractFactory == null) {
            this.keyStore = null;
            this.trustStore = null;
        } else {
            this.keyStore = abstractFactory.getKeyStore();
            this.trustStore = abstractFactory.getTrustStore();
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }
}

