/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action0;

public abstract class Scheduler {
    public abstract Worker createWorker();

    public int parallelism() {
        return Runtime.getRuntime().availableProcessors();
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public static abstract class Worker
    implements Subscription {
        public abstract Subscription schedule(Action0 var1);

        public abstract Subscription schedule(Action0 var1, long var2, TimeUnit var4);

        public Subscription schedulePeriodically(final Action0 action, long initialDelay, long period, TimeUnit unit) {
            final long periodInNanos = unit.toNanos(period);
            Action0 recursiveAction = new Action0(){

                @Override
                public void call() {
                    if (!Worker.this.isUnsubscribed()) {
                        long startedAt = Worker.this.now();
                        action.call();
                        long timeTakenByActionInNanos = TimeUnit.MILLISECONDS.toNanos(Worker.this.now() - startedAt);
                        Worker.this.schedule(this, periodInNanos - timeTakenByActionInNanos, TimeUnit.NANOSECONDS);
                    }
                }
            };
            return this.schedule(recursiveAction, initialDelay, unit);
        }

        public long now() {
            return System.currentTimeMillis();
        }
    }
}

