/*
 * Decompiled with CFR 0.152.
 */
package rx.exceptions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private static final long serialVersionUID = 3026362227162912146L;
    private final List<Throwable> exceptions;
    private final String message;
    private final Throwable cause;

    public CompositeException(String messagePrefix, Collection<Throwable> errors) {
        ArrayList<Throwable> _exceptions = new ArrayList<Throwable>();
        CompositeExceptionCausalChain _cause = new CompositeExceptionCausalChain();
        int count = 0;
        for (Throwable e : errors) {
            ++count;
            CompositeException.attachCallingThreadStack(_cause, e);
            _exceptions.add(e);
        }
        this.exceptions = Collections.unmodifiableList(_exceptions);
        this.message = count + " exceptions occurred. See them in causal chain below.";
        this.cause = _cause;
    }

    public CompositeException(Collection<Throwable> errors) {
        this(null, errors);
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.cause;
    }

    private static String getStackTraceAsString(StackTraceElement[] stack) {
        StringBuilder s = new StringBuilder();
        boolean firstLine = true;
        for (StackTraceElement e : stack) {
            if (e.toString().startsWith("java.lang.Thread.getStackTrace")) continue;
            if (!firstLine) {
                s.append("\n\t");
            }
            s.append(e.toString());
            firstLine = false;
        }
        return s.toString();
    }

    static void attachCallingThreadStack(Throwable e, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        while (e.getCause() != null && !seenCauses.contains((e = e.getCause()).getCause())) {
            seenCauses.add(e.getCause());
        }
        try {
            e.initCause(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static final class CompositeExceptionCausalChain
    extends RuntimeException {
        private static final long serialVersionUID = 3875212506787802066L;
        static String MESSAGE = "Chain of Causes for CompositeException In Order Received =>";

        CompositeExceptionCausalChain() {
        }

        @Override
        public String getMessage() {
            return MESSAGE;
        }
    }
}

