/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorFailedException;
import rx.exceptions.OnErrorNotImplementedException;
import rx.plugins.RxJavaPlugins;

public class SafeSubscriber<T>
extends Subscriber<T> {
    private final Subscriber<? super T> actual;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);

    public SafeSubscriber(Subscriber<? super T> actual) {
        super(actual);
        this.actual = actual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        if (this.isFinished.compareAndSet(false, true)) {
            try {
                this.actual.onCompleted();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this._onError(e);
            }
            finally {
                this.unsubscribe();
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Exceptions.throwIfFatal(e);
        if (this.isFinished.compareAndSet(false, true)) {
            this._onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        try {
            if (!this.isFinished.get()) {
                this.actual.onNext(args);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            this.onError(e);
        }
    }

    protected void _onError(Throwable e) {
        try {
            RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
        }
        catch (Throwable pluginException) {
            this.handlePluginException(pluginException);
        }
        try {
            this.actual.onError(e);
        }
        catch (Throwable e2) {
            if (e2 instanceof OnErrorNotImplementedException) {
                try {
                    this.unsubscribe();
                }
                catch (Throwable unsubscribeException) {
                    try {
                        RxJavaPlugins.getInstance().getErrorHandler().handleError(unsubscribeException);
                    }
                    catch (Throwable pluginException) {
                        this.handlePluginException(pluginException);
                    }
                    throw new RuntimeException("Observer.onError not implemented and error while unsubscribing.", new CompositeException(Arrays.asList(e, unsubscribeException)));
                }
                throw (OnErrorNotImplementedException)e2;
            }
            try {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e2);
            }
            catch (Throwable pluginException) {
                this.handlePluginException(pluginException);
            }
            try {
                this.unsubscribe();
            }
            catch (Throwable unsubscribeException) {
                try {
                    RxJavaPlugins.getInstance().getErrorHandler().handleError(unsubscribeException);
                }
                catch (Throwable pluginException) {
                    this.handlePluginException(pluginException);
                }
                throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError and during unsubscription.", new CompositeException(Arrays.asList(e, e2, unsubscribeException)));
            }
            throw new OnErrorFailedException("Error occurred when trying to propagate error to Observer.onError", new CompositeException(Arrays.asList(e, e2)));
        }
        try {
            this.unsubscribe();
        }
        catch (RuntimeException unsubscribeException) {
            try {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(unsubscribeException);
            }
            catch (Throwable pluginException) {
                this.handlePluginException(pluginException);
            }
            throw new OnErrorFailedException(unsubscribeException);
        }
    }

    private void handlePluginException(Throwable pluginException) {
        System.err.println("RxJavaErrorHandler threw an Exception. It shouldn't. => " + pluginException.getMessage());
        pluginException.printStackTrace();
    }

    public Subscriber<? super T> getActual() {
        return this.actual;
    }
}

