/*
 * Decompiled with CFR 0.152.
 */
package rx.observers;

import rx.Observer;

public class SerializedObserver<T>
implements Observer<T> {
    private final Observer<? super T> actual;
    private boolean emitting = false;
    private boolean terminated = false;
    private FastList queue;
    private static final int MAX_DRAIN_ITERATION = Integer.MAX_VALUE;
    private static final Object NULL_SENTINEL = new Object();
    private static final Object COMPLETE_SENTINEL = new Object();

    public SerializedObserver(Observer<? super T> s) {
        this.actual = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        FastList list;
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new FastList();
                }
                this.queue.add(COMPLETE_SENTINEL);
                return;
            }
            this.emitting = true;
            list = this.queue;
            this.queue = null;
        }
        this.drainQueue(list);
        this.actual.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        FastList list;
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new FastList();
                }
                this.queue.add(new ErrorSentinel(e));
                return;
            }
            this.emitting = true;
            list = this.queue;
            this.queue = null;
        }
        this.drainQueue(list);
        this.actual.onError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(T t) {
        FastList list;
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            if (this.emitting) {
                if (this.queue == null) {
                    this.queue = new FastList();
                }
                this.queue.add(t != null ? t : NULL_SENTINEL);
                return;
            }
            this.emitting = true;
            list = this.queue;
            this.queue = null;
        }
        boolean skipFinal = false;
        try {
            int iter = Integer.MAX_VALUE;
            this.drainQueue(list);
            if (iter == Integer.MAX_VALUE) {
                this.actual.onNext(t);
            }
            if (--iter > 0) {
                SerializedObserver serializedObserver2 = this;
                synchronized (serializedObserver2) {
                    block28: {
                        list = this.queue;
                        this.queue = null;
                        if (list != null) break block28;
                        this.emitting = false;
                        skipFinal = true;
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 5, 10, 27] lbl39 : MonitorExitStatement: MONITOREXIT : var5_8
                }
            }
        }
        finally {
            if (!skipFinal) {
                SerializedObserver serializedObserver3 = this;
                synchronized (serializedObserver3) {
                    if (this.terminated) {
                        list = this.queue;
                        this.queue = null;
                    } else {
                        this.emitting = false;
                        list = null;
                    }
                }
            }
        }
    }

    void drainQueue(FastList list) {
        if (list == null || list.size == 0) {
            return;
        }
        for (Object v : list.array) {
            if (v == null) break;
            if (v == NULL_SENTINEL) {
                this.actual.onNext(null);
                continue;
            }
            if (v == COMPLETE_SENTINEL) {
                this.actual.onCompleted();
                continue;
            }
            if (v.getClass() == ErrorSentinel.class) {
                this.actual.onError(((ErrorSentinel)v).e);
                continue;
            }
            this.actual.onNext(v);
        }
    }

    private static final class ErrorSentinel {
        final Throwable e;

        ErrorSentinel(Throwable e) {
            this.e = e;
        }
    }

    static final class FastList {
        Object[] array;
        int size;

        FastList() {
        }

        public void add(Object o) {
            int s = this.size;
            Object[] a = this.array;
            if (a == null) {
                this.array = a = new Object[16];
            } else if (s == a.length) {
                Object[] array2 = new Object[s + (s >> 2)];
                System.arraycopy(a, 0, array2, 0, s);
                this.array = a = array2;
            }
            a[s] = o;
            this.size = s + 1;
        }
    }
}

