/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;

public final class BlockingOperatorNext {
    public static <T> Iterable<T> next(final Observable<? extends T> items) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                NextObserver nextObserver = new NextObserver();
                NextIterator nextIterator = new NextIterator(nextObserver);
                items.materialize().subscribe(nextObserver);
                return nextIterator;
            }
        };
    }

    private static class NextObserver<T>
    extends Subscriber<Notification<? extends T>> {
        private final BlockingQueue<Notification<? extends T>> buf = new ArrayBlockingQueue<Notification<? extends T>>(1);
        private final AtomicBoolean waiting = new AtomicBoolean(false);

        private NextObserver() {
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onNext(Notification<? extends T> args) {
            if (this.waiting.getAndSet(false) || !args.isOnNext()) {
                Notification toOffer = args;
                while (!this.buf.offer(toOffer)) {
                    Notification concurrentItem = (Notification)this.buf.poll();
                    if (concurrentItem == null || concurrentItem.isOnNext()) continue;
                    toOffer = concurrentItem;
                }
            }
        }

        public Notification<? extends T> takeNext() throws InterruptedException {
            this.waiting.set(true);
            return this.buf.take();
        }
    }

    static final class NextIterator<T>
    implements Iterator<T> {
        private final NextObserver<? extends T> observer;
        private T next;
        private boolean hasNext = true;
        private boolean isNextConsumed = true;
        private Throwable error = null;

        private NextIterator(NextObserver<? extends T> observer) {
            this.observer = observer;
        }

        void setWaiting(boolean value) {
            ((NextObserver)this.observer).waiting.set(value);
        }

        @Override
        public boolean hasNext() {
            if (this.error != null) {
                throw Exceptions.propagate(this.error);
            }
            if (!this.hasNext) {
                return false;
            }
            if (!this.isNextConsumed) {
                return true;
            }
            return this.moveToNext();
        }

        private boolean moveToNext() {
            try {
                Notification<T> nextNotification = this.observer.takeNext();
                if (nextNotification.isOnNext()) {
                    this.isNextConsumed = false;
                    this.next = nextNotification.getValue();
                    return true;
                }
                this.hasNext = false;
                if (nextNotification.isOnCompleted()) {
                    return false;
                }
                if (nextNotification.isOnError()) {
                    this.error = nextNotification.getThrowable();
                    throw Exceptions.propagate(this.error);
                }
                throw new IllegalStateException("Should not reach here");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.error = e;
                throw Exceptions.propagate(this.error);
            }
        }

        @Override
        public T next() {
            if (this.error != null) {
                throw Exceptions.propagate(this.error);
            }
            if (this.hasNext()) {
                this.isNextConsumed = true;
                return this.next;
            }
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read only iterator");
        }
    }
}

