/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAll<T>
implements Observable.Operator<Boolean, T> {
    private final Func1<? super T, Boolean> predicate;

    public OperatorAll(Func1<? super T, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super Boolean> child) {
        return new Subscriber<T>(child){
            boolean done;

            @Override
            public void onNext(T t) {
                boolean result = (Boolean)OperatorAll.this.predicate.call(t);
                if (!result && !this.done) {
                    this.done = true;
                    child.onNext(false);
                    child.onCompleted();
                    this.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    child.onNext(true);
                    child.onCompleted();
                }
            }
        };
    }
}

