/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observers.SerializedSubscriber;
import rx.operators.NotificationLite;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class OperatorConcat<T>
implements Observable.Operator<T, Observable<? extends T>> {
    final NotificationLite<Observable<? extends T>> nl = NotificationLite.instance();

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        SerialSubscription current = new SerialSubscription();
        child.add(current);
        return new ConcatSubscriber(s, current);
    }

    final class ConcatSubscriber
    extends Subscriber<Observable<? extends T>> {
        private final Subscriber<T> s;
        private final SerialSubscription current;
        final ConcurrentLinkedQueue<Object> queue;
        final AtomicInteger wip;

        public ConcatSubscriber(Subscriber<T> s, SerialSubscription current) {
            super(s);
            this.s = s;
            this.current = current;
            this.queue = new ConcurrentLinkedQueue();
            this.wip = new AtomicInteger();
            this.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    ConcatSubscriber.this.queue.clear();
                }
            }));
        }

        @Override
        public void onNext(Observable<? extends T> t) {
            this.queue.add(OperatorConcat.this.nl.next(t));
            if (this.wip.getAndIncrement() == 0) {
                this.subscribeNext();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.s.onError(e);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            this.queue.add(OperatorConcat.this.nl.completed());
            if (this.wip.getAndIncrement() == 0) {
                this.subscribeNext();
            }
        }

        void subscribeNext() {
            Object o = this.queue.poll();
            if (OperatorConcat.this.nl.isCompleted(o)) {
                this.s.onCompleted();
            } else if (o != null) {
                Observable obs = OperatorConcat.this.nl.getValue(o);
                Subscriber sourceSub = new Subscriber<T>(){

                    @Override
                    public void onNext(T t) {
                        ConcatSubscriber.this.s.onNext(t);
                    }

                    @Override
                    public void onError(Throwable e) {
                        ConcatSubscriber.this.onError(e);
                    }

                    @Override
                    public void onCompleted() {
                        if (ConcatSubscriber.this.wip.decrementAndGet() > 0) {
                            ConcatSubscriber.this.subscribeNext();
                        }
                    }
                };
                this.current.set(sourceSub);
                obs.unsafeSubscribe(sourceSub);
            }
        }
    }
}

