/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;

public final class OperatorDelaySubscription<T>
implements Observable.OnSubscribe<T> {
    final Observable<? extends T> source;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;

    public OperatorDelaySubscription(Observable<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void call(final Subscriber<? super T> s) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        s.add(worker);
        worker.schedule(new Action0(){

            @Override
            public void call() {
                if (!s.isUnsubscribed()) {
                    OperatorDelaySubscription.this.source.unsafeSubscribe(s);
                }
            }
        }, this.time, this.unit);
    }
}

