/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observers.SerializedSubscriber;
import rx.operators.OperatorDelay;
import rx.subscriptions.CompositeSubscription;

public final class OperatorDelayWithSelector<T, U, V>
implements Observable.OnSubscribe<T> {
    final Observable<? extends T> source;
    final Func0<? extends Observable<U>> subscriptionDelay;
    final Func1<? super T, ? extends Observable<V>> itemDelay;

    public OperatorDelayWithSelector(Observable<? extends T> source, Func1<? super T, ? extends Observable<V>> itemDelay) {
        this.source = source;
        this.subscriptionDelay = new Func0<Observable<U>>(){

            @Override
            public Observable<U> call() {
                return Observable.just(null);
            }
        };
        this.itemDelay = itemDelay;
    }

    public OperatorDelayWithSelector(Observable<? extends T> source, Func0<? extends Observable<U>> subscriptionDelay, Func1<? super T, ? extends Observable<V>> itemDelay) {
        this.source = source;
        this.subscriptionDelay = subscriptionDelay;
        this.itemDelay = itemDelay;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        Observable<U> osub;
        final SerializedSubscriber<T> s = new SerializedSubscriber<T>(child);
        final CompositeSubscription csub = new CompositeSubscription();
        child.add(csub);
        try {
            osub = this.subscriptionDelay.call();
        }
        catch (Throwable e) {
            s.onError(e);
            return;
        }
        Observable seqs = this.source.map(new Func1<T, Observable<T>>(){

            @Override
            public Observable<T> call(T x) {
                final OperatorDelay.Emitter e = new OperatorDelay.Emitter(x);
                Observable itemObs = OperatorDelayWithSelector.this.itemDelay.call(x);
                Subscriber itemSub = new Subscriber<V>(){
                    boolean once = true;

                    @Override
                    public void onNext(V t) {
                        this.emit();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        s.onError(e2);
                        s.unsubscribe();
                    }

                    @Override
                    public void onCompleted() {
                        this.emit();
                    }

                    void emit() {
                        if (this.once) {
                            this.once = false;
                            e.call();
                            csub.remove(this);
                        }
                    }
                };
                csub.add(itemSub);
                itemObs.unsafeSubscribe(itemSub);
                return Observable.create(e);
            }
        });
        final Observable delayed = Observable.merge(seqs);
        Subscriber osubSub = new Subscriber<U>(child){
            boolean subscribed;

            @Override
            public void onNext(U ignored) {
                this.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                if (!this.subscribed) {
                    s.onError(e);
                    this.unsubscribe();
                }
            }

            @Override
            public void onCompleted() {
                if (!this.subscribed) {
                    this.subscribed = true;
                    delayed.unsafeSubscribe(s);
                }
            }
        };
        osub.unsafeSubscribe(osubSub);
    }
}

